/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.onboard;

import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.android.SDKManager;
import com.crashlytics.tools.android.onboard.OnboardException;
import java.util.concurrent.CountDownLatch;

public class SdkOnboarder {
    private final SDKManager _manager;
    private final String _apiKey;
    private final CountDownLatch _sdkAvailableLatch = new CountDownLatch(1);
    private final Runnable ensureSdkAvailableRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                SDKManager sdkManager = SdkOnboarder.this.getSdkManager();
                String apiKey = SdkOnboarder.this._apiKey;
                if (sdkManager.isSdkAvailable(apiKey)) {
                    DeveloperTools.logD("An SDK is available for API key " + apiKey + ". Proceeding with onboarding.");
                    SdkOnboarder.this._sdkAvailableLatch.countDown();
                } else {
                    DeveloperTools.logD("An SDK is not available for API key " + apiKey + ". Requesting a download and retrying.");
                    sdkManager.updateCachedSDK(DeveloperTools.getWebApi(), apiKey);
                    Thread.sleep(1000L);
                    SdkOnboarder.this.ensureSdkAvailable();
                }
            }
            catch (Exception e) {
                DeveloperTools.logE("Encountered an error while ensuring an SDK is present.", e);
            }
        }
    };

    public SdkOnboarder(String apiKey, SDKManager manager) {
        this._apiKey = apiKey;
        this._manager = manager;
    }

    public SDKManager getSdkManager() {
        return this._manager;
    }

    private void ensureSdkAvailable() {
        new Thread(this.ensureSdkAvailableRunnable, "Crashlytics Ensure SDK Present").start();
    }

    public void updateBuildSystem() throws OnboardException {
        this.ensureSdkAvailable();
        try {
            this._sdkAvailableLatch.await();
        }
        catch (InterruptedException e) {
            DeveloperTools.logE("Crashlytics was interrupted while waiting for an SDK to be available.", e);
        }
    }
}

