/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.project;

import com.crashlytics.tools.android.project.AndroidProject;
import com.crashlytics.tools.android.project.ManifestData;
import com.crashlytics.tools.android.project.ManifestProvider;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public abstract class AbstractManifestProvider
implements ManifestProvider {
    @Override
    public abstract String getManifestString() throws ManifestData.ManifestIOException;

    protected abstract AndroidProject getAndroidProject() throws IOException;

    @Override
    public ManifestData getManifestData() throws ManifestData.ManifestIOException {
        try {
            return this.getAndroidProject().getManifestData();
        }
        catch (IOException e) {
            throw new ManifestData.ManifestIOException("Crashlytics could not retrieve the manifest data from the android project.");
        }
    }

    @Override
    public InputStream getManifestStream() throws ManifestData.ManifestIOException {
        return new ByteArrayInputStream(this.getManifestString().getBytes());
    }

    @Override
    public File getManifestFile() throws ManifestData.ManifestIOException {
        try {
            return this.getAndroidProject().getManifestFile();
        }
        catch (IOException e) {
            throw new ManifestData.ManifestIOException("Crashlytics could not retrieve the manifest file from the android project.");
        }
    }
}

