/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.project;

import com.crashlytics.api.AppRelease;
import com.crashlytics.api.AuthenticationException;
import com.crashlytics.api.DistributionData;
import com.crashlytics.api.WebApi;
import com.crashlytics.tools.utils.ApkUtils;
import java.io.File;
import java.io.IOException;

public class DistributionUploader {
    private final WebApi _webApi;

    public DistributionUploader(WebApi api) {
        this._webApi = api;
    }

    public boolean uploadDistribution(String apkPath, String apiKey, String secretApiKey) throws IOException, AuthenticationException {
        File apkFile = new File(apkPath);
        long builtAtSeconds = apkFile.lastModified();
        AppRelease appRelease = ApkUtils.extractAppDataFromApk(apkFile);
        DistributionData distributionData = new DistributionData(apkFile, builtAtSeconds);
        return this._webApi.createDistribution(apiKey, secretApiKey, appRelease, distributionData, true);
    }
}

