/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.utils.abx;

import com.android.sdklib.util.SparseArray;
import com.crashlytics.tools.utils.ApkUtils;
import com.crashlytics.tools.utils.ParseStringStrategy;
import com.crashlytics.tools.utils.Utf16ParseStringStrategy;
import com.crashlytics.tools.utils.Utf8ParseStringStrategy;
import com.crashlytics.tools.utils.abx.AbxAttribute;
import com.crashlytics.tools.utils.abx.AbxNode;
import com.crashlytics.tools.utils.abx.AbxStringPoolEntry;
import com.crashlytics.tools.utils.abx.AbxUtils;
import com.crashlytics.tools.utils.abx.PositionInputStream;
import com.crashlytics.tools.utils.abx.StringResourcesMap;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Stack;

public class AbxParser {
    private static final int STRING_LENGTH_BYTES = 2;
    private final byte[] mData;
    private byte[] _chunkTypeBuf = new byte[2];
    private byte[] _headerSizeBuf = new byte[2];
    private byte[] _chunkSizeBuf = new byte[4];
    private int _headerSize;
    private int _chunkSize;
    private byte[] _buf1 = new byte[1];
    private byte[] _buf2 = new byte[2];
    private byte[] _buf4 = new byte[4];
    private int _stringTypeId = -1;
    private SparseArray<AbxStringPoolEntry> _stringPoolManifest = new SparseArray();
    private SparseArray<AbxStringPoolEntry> _stringPoolValues = new SparseArray();
    private SparseArray<AbxStringPoolEntry> _stringPoolKeys = new SparseArray();
    private SparseArray<AbxStringPoolEntry> _stringPoolResTypes = new SparseArray();
    private ArrayList<Integer> _resMap = new ArrayList();
    private int nsPrefixIndex = -1;
    private int nsUriIndex = -1;
    private int nsLineNumber = 0;

    public AbxParser(byte[] binaryXml) {
        this.mData = binaryXml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbxNode parseManifest() throws IOException {
        FilterInputStream in = null;
        AbxNode root = null;
        try {
            in = new PositionInputStream(new ByteArrayInputStream(this.mData));
            in.read(this._chunkTypeBuf);
            if (AbxUtils.toInt(this._chunkTypeBuf, false) != 3) {
                ApkUtils.logW("Invalid Android Binary XML file.", null);
                AbxNode abxNode = null;
                return abxNode;
            }
            in.read(this._headerSizeBuf);
            int headerSize = AbxUtils.toInt(this._headerSizeBuf, false);
            in.read(this._chunkSizeBuf);
            int chunkSize = AbxUtils.toInt(this._chunkSizeBuf, false);
            ApkUtils.log("Header Size: " + headerSize + " Chunk size: " + chunkSize);
            in.read(this._chunkTypeBuf);
            if (AbxUtils.toInt(this._chunkTypeBuf, false) == 1) {
                ApkUtils.log("String Pool for manifest...");
                in.read(this._headerSizeBuf);
                headerSize = AbxUtils.toInt(this._headerSizeBuf, false);
                in.read(this._chunkSizeBuf);
                chunkSize = AbxUtils.toInt(this._chunkSizeBuf, false);
                ApkUtils.log("String Pool for manifest...Header Size: " + headerSize + " Chunk Size: " + chunkSize);
                byte[] spBuf = new byte[chunkSize - 8];
                in.read(spBuf);
                this.parseStringPool(spBuf, headerSize, chunkSize, this._stringPoolManifest, new Utf16ParseStringStrategy());
                in.read(this._chunkTypeBuf);
            }
            if (AbxUtils.toInt(this._chunkTypeBuf, false) == 384) {
                in.read(this._headerSizeBuf);
                headerSize = AbxUtils.toInt(this._headerSizeBuf, false);
                in.read(this._chunkSizeBuf);
                chunkSize = AbxUtils.toInt(this._chunkSizeBuf, false);
                byte[] rmBuf = new byte[chunkSize - 8];
                in.read(rmBuf);
                this.parseResMapping(rmBuf, headerSize, chunkSize);
                in.read(this._chunkTypeBuf);
            }
            if (AbxUtils.toInt(this._chunkTypeBuf, false) == 256) {
                in.read(this._headerSizeBuf);
                headerSize = AbxUtils.toInt(this._headerSizeBuf, false);
                in.read(this._chunkSizeBuf);
                chunkSize = AbxUtils.toInt(this._chunkSizeBuf, false);
                byte[] nsStartBuf = new byte[chunkSize - 8];
                in.read(nsStartBuf);
                this.parseStartNameSpace(nsStartBuf, headerSize, chunkSize);
            }
            in.read(this._chunkTypeBuf);
            int chunkType = AbxUtils.toInt(this._chunkTypeBuf, false);
            Stack<AbxNode> currentParent = new Stack<AbxNode>();
            while (chunkType != 257) {
                ApkUtils.log("Parsing XML node...Chunk_Type " + chunkType);
                in.read(this._headerSizeBuf);
                headerSize = AbxUtils.toInt(this._headerSizeBuf, false);
                in.read(this._chunkSizeBuf);
                chunkSize = AbxUtils.toInt(this._chunkSizeBuf, false);
                byte[] elementBuf = new byte[chunkSize - 8];
                in.read(elementBuf);
                if (chunkType == 258) {
                    AbxNode parent = currentParent.size() > 0 ? (AbxNode)currentParent.peek() : null;
                    currentParent.add(this.parseXMLStart(parent, elementBuf, headerSize, chunkSize));
                } else if (chunkType == 259) {
                    this.parseXMLEnd(elementBuf, headerSize, chunkSize);
                    root = (AbxNode)currentParent.pop();
                }
                in.read(this._chunkTypeBuf);
                chunkType = AbxUtils.toInt(this._chunkTypeBuf, false);
            }
            if (chunkType == 257) {
                in.read(this._headerSizeBuf);
                headerSize = AbxUtils.toInt(this._headerSizeBuf, false);
                in.read(this._chunkSizeBuf);
                chunkSize = AbxUtils.toInt(this._chunkSizeBuf, false);
                byte[] nsEndBuf = new byte[chunkSize - 8];
                in.read(nsEndBuf);
                this.parseEndNameSpace(nsEndBuf, headerSize, chunkSize);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return root;
    }

    private void parseStringPool(byte[] spBuf, int headerSize, int chunkSize, SparseArray<AbxStringPoolEntry> list, ParseStringStrategy parseStringStrategy) throws IOException {
        int i;
        ByteArrayInputStream in = new ByteArrayInputStream(spBuf);
        byte[] buffer = new byte[4];
        in.read(buffer);
        int stringCount = AbxUtils.toInt(buffer, false);
        in.read(buffer);
        int styleCount = AbxUtils.toInt(buffer, false);
        in.read(buffer);
        int flag = AbxUtils.toInt(buffer, false);
        in.read(buffer);
        int stringStart = AbxUtils.toInt(buffer, false);
        in.read(buffer);
        int styleStart = AbxUtils.toInt(buffer, false);
        ApkUtils.log("String Count: " + stringCount + " Style Count: " + styleCount + " Flag: " + flag + " String Start: " + stringStart + " Style Start: " + styleStart);
        int[] stringIndices = new int[stringCount];
        if (stringCount > 0) {
            for (i = 0; i < stringCount; ++i) {
                in.read(buffer);
                stringIndices[i] = AbxUtils.toInt(buffer, false);
            }
        }
        if (styleCount > 0) {
            in.skip(styleCount * 4);
        }
        for (i = 0; i < stringCount; ++i) {
            int stringLen = 0;
            if (i == stringCount - 1) {
                if (styleStart == 0) {
                    stringLen = chunkSize - stringIndices[i] - headerSize - 4 * stringCount;
                    ApkUtils.log("Last String size: " + stringLen + " Chunk_Size: " + chunkSize + " Index: " + stringIndices[i]);
                } else {
                    stringLen = styleStart - stringIndices[i];
                }
            } else {
                stringLen = stringIndices[i + 1] - stringIndices[i];
            }
            byte[] shortBuffer = new byte[2];
            in.read(shortBuffer);
            byte[] buf = new byte[stringLen - 2];
            in.read(buf);
            String str = parseStringStrategy.parseStringFrom(buf);
            ApkUtils.log("Found in String Pool: " + str + " offset: " + stringIndices[i] + ", index: " + i);
            if (list.size() < i && list.valueAt(i) != null) {
                throw new IOException("Overwriting value at index " + i + ": old value: " + list.valueAt(i) + ", new value: " + str);
            }
            list.append(i, new AbxStringPoolEntry(str, i));
        }
        ApkUtils.log("[String Pool] Size: " + this._stringPoolValues.size());
        ApkUtils.log("[String Pool] " + this._stringPoolValues);
    }

    private void parseResMapping(byte[] rmBuf, int headerSize, int chunkSize) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(rmBuf);
        int resIdCount = rmBuf.length / 4;
        byte[] intBuffer = new byte[4];
        for (int i = 0; i < resIdCount; ++i) {
            in.read(intBuffer);
            this._resMap.add(AbxUtils.toInt(intBuffer, false));
        }
        ApkUtils.log("[Res Mapping] Resource Mapping " + this._resMap);
    }

    private void parseStartNameSpace(byte[] nsStartBuf, int headerSize, int chunkSize) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(nsStartBuf);
        byte[] intBuffer = new byte[4];
        in.read(intBuffer);
        this.nsLineNumber = AbxUtils.toInt(intBuffer, false);
        in.read(intBuffer);
        in.read(intBuffer);
        this.nsPrefixIndex = AbxUtils.toInt(intBuffer, false);
        in.read(intBuffer);
        this.nsUriIndex = AbxUtils.toInt(intBuffer, false);
        ApkUtils.log("[Namespace Start]Line Number: " + this.nsLineNumber + " Prefix: " + this._stringPoolManifest.valueAt(this.nsPrefixIndex) + " URI: " + this._stringPoolManifest.valueAt(this.nsUriIndex));
    }

    private AbxNode parseXMLStart(AbxNode parent, byte[] xmlStartBuf, int headerSize, int chunkSize) throws IOException {
        AbxNode node = new AbxNode(parent);
        ByteArrayInputStream in = new ByteArrayInputStream(xmlStartBuf);
        byte[] intBuf = new byte[4];
        in.read(intBuf);
        int lineNumber = AbxUtils.toInt(intBuf, false);
        node.setLineNumber(lineNumber);
        in.read(intBuf);
        in.read(intBuf);
        in.read(intBuf);
        int nameIndex = AbxUtils.toInt(intBuf, false);
        byte[] shortBuffer = new byte[2];
        in.read(shortBuffer);
        in.read(shortBuffer);
        in.read(shortBuffer);
        int attributeCount = AbxUtils.toInt(shortBuffer, false);
        in.skip(6L);
        ApkUtils.log("[XML Node] Name: " + (nameIndex == -1 ? "-1" : this._stringPoolManifest.valueAt(nameIndex)) + " Attr count: " + attributeCount);
        if (nameIndex != -1) {
            node.setName(this._stringPoolManifest.valueAt(nameIndex).getValue());
            if (this.nsPrefixIndex != -1 && this.nsUriIndex != -1) {
                node.setNamespacePrefix(this._stringPoolManifest.valueAt(this.nsPrefixIndex).getValue());
                node.setNamespaceURI(this._stringPoolManifest.valueAt(this.nsUriIndex).getValue());
            }
        }
        if (attributeCount == 0) {
            return node;
        }
        for (int i = 0; i < attributeCount; ++i) {
            AbxAttribute attr = new AbxAttribute();
            in.read(intBuf);
            in.read(intBuf);
            int attrNameIndex = AbxUtils.toInt(intBuf, false);
            in.read(intBuf);
            int attrRawValue = AbxUtils.toInt(intBuf, false);
            String attrValue = "";
            if (attrRawValue == -1) {
                in.read(shortBuffer);
                int dataSize = AbxUtils.toInt(shortBuffer, false);
                in.skip(1L);
                int dataType = in.read();
                in.read(intBuf);
                int data = AbxUtils.toInt(intBuf, false);
                attrValue = "" + data;
            } else {
                attrValue = this._stringPoolManifest.valueAt(attrRawValue).getValue();
                in.skip(8L);
            }
            if (attrNameIndex == -1) continue;
            attr.setName(this._stringPoolManifest.valueAt(attrNameIndex).getValue());
            attr.setValue(attrValue);
            attr.setIndex(i);
            node.addAttribute(attr);
        }
        return node;
    }

    private void parseXMLEnd(byte[] xmlEndBuf, int headerSize, int chunkSize) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(xmlEndBuf);
        byte[] intBuffer = new byte[4];
        in.read(intBuffer);
        int lineNumber = AbxUtils.toInt(intBuffer, false);
        in.read(intBuffer);
        int comment = AbxUtils.toInt(intBuffer, false);
        in.read(intBuffer);
        int nsIndex = AbxUtils.toInt(intBuffer, false);
        in.read(intBuffer);
        int nameIndex = AbxUtils.toInt(intBuffer, false);
        ApkUtils.log("[XML_END] Line Number: " + lineNumber + " Namespace: " + nsIndex + " Name: " + (nameIndex == -1 ? "-1" : this._stringPoolManifest.valueAt(nameIndex)));
        if (nameIndex != -1) {
            AbxNode node = new AbxNode();
            node.setName(this._stringPoolManifest.valueAt(nameIndex).getValue());
            node.setLineNumber(lineNumber);
            node.setNamespacePrefix(this._stringPoolManifest.valueAt(this.nsPrefixIndex).getValue());
            node.setNamespaceURI(this._stringPoolManifest.valueAt(this.nsUriIndex).getValue());
        }
    }

    private void parseEndNameSpace(byte[] nsStartBuf, int headerSize, int chunkSize) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(nsStartBuf);
        byte[] intBuffer = new byte[4];
        in.read(intBuffer);
        int lineNumber = AbxUtils.toInt(intBuffer, false);
        in.read(intBuffer);
        int comment = AbxUtils.toInt(intBuffer, false);
        in.read(intBuffer);
        int prefixIndex = AbxUtils.toInt(intBuffer, false);
        in.read(intBuffer);
        int uriIndex = AbxUtils.toInt(intBuffer, false);
        ApkUtils.log("[Namespace END]Line Number: " + lineNumber + " Prefix: " + prefixIndex + " URI: " + uriIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringResourcesMap parseResourceTable(ParseStringStrategy strategy) throws IOException {
        StringResourcesMap map = new StringResourcesMap();
        ApkUtils.log("[Res_Table] Parsing resources.arsc...");
        FilterInputStream in = null;
        try {
            in = new PositionInputStream(new ByteArrayInputStream(this.mData));
            in.read(this._buf2);
            if (AbxUtils.toInt(this._buf2, false) != 2) {
                ApkUtils.logW("Invalid resources.arsc file.", null);
                StringResourcesMap stringResourcesMap = null;
                return stringResourcesMap;
            }
            in.read(this._buf2);
            in.read(this._buf4);
            in.read(this._buf4);
            in.read(this._buf2);
            if (AbxUtils.toInt(this._buf2, false) != 1) {
                ApkUtils.logW("Expected string pool containing values.", null);
                StringResourcesMap stringResourcesMap = null;
                return stringResourcesMap;
            }
            ApkUtils.log("String Pool...");
            in.read(this._buf2);
            this._headerSize = AbxUtils.toInt(this._buf2, false);
            in.read(this._buf4);
            this._chunkSize = AbxUtils.toInt(this._buf4, false);
            byte[] spBuf = new byte[this._chunkSize - 8];
            in.read(spBuf);
            ApkUtils.log("Parsing string pool at absolute loc: " + ((PositionInputStream)in).getPosition());
            this.parseStringPool(spBuf, this._headerSize, this._chunkSize, this._stringPoolValues, strategy);
            in.read(this._buf2);
            ApkUtils.log("[Res_Table] Chunk type: " + AbxUtils.toInt(this._buf2, false));
            ApkUtils.log("=== parseResPackage() ===");
            if (AbxUtils.toInt(this._buf2, false) == 512) {
                this.parseResPackage((PositionInputStream)in, map, strategy);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return map;
    }

    private void parseResPackage(PositionInputStream in, StringResourcesMap map, ParseStringStrategy strategy) throws IOException {
        block11: {
            block10: {
                int i;
                int entryCount;
                byte[] spBuf;
                in.read(this._buf2);
                this._headerSize = AbxUtils.toInt(this._buf2, false);
                in.read(this._buf4);
                this._chunkSize = AbxUtils.toInt(this._buf4, false);
                in.read(this._buf4);
                int packgageId = AbxUtils.toInt(this._buf4, false);
                ApkUtils.log("String Pool...Header Size: " + this._headerSize + " Chunk Size: " + this._chunkSize + " Packg_ID: " + packgageId);
                byte[] packageNameBuffer = new byte[256];
                in.read(packageNameBuffer);
                String packageName = AbxUtils.toString(packageNameBuffer, false);
                ApkUtils.log("Package Name: " + packageName);
                in.read(this._buf4);
                int typeStrings = AbxUtils.toInt(this._buf4, false);
                in.read(this._buf4);
                int lastPublicType = AbxUtils.toInt(this._buf4, false);
                in.read(this._buf4);
                int keyString = AbxUtils.toInt(this._buf4, false);
                in.read(this._buf4);
                int lastPublicKey = AbxUtils.toInt(this._buf4, false);
                ApkUtils.log("[Res_Table] typeStrings=" + typeStrings + " lastPublicType=" + lastPublicType + " keyString=" + keyString + " lastPublicKey=" + lastPublicKey);
                in.read(this._buf2);
                if (AbxUtils.toInt(this._buf2, false) == 1) {
                    ApkUtils.log("typeString String Pool...");
                    in.read(this._buf2);
                    this._headerSize = AbxUtils.toInt(this._buf2, false);
                    in.read(this._buf4);
                    this._chunkSize = AbxUtils.toInt(this._buf4, false);
                    ApkUtils.log("String Pool...Header Size: " + this._headerSize + " Chunk Size: " + this._chunkSize);
                    spBuf = new byte[this._chunkSize - 8];
                    in.read(spBuf);
                    this.parseStringPool(spBuf, this._headerSize, this._chunkSize, this._stringPoolResTypes, new Utf8ParseStringStrategy());
                    this.tryToFindStringResId();
                    if (this._stringTypeId < 0) {
                        this._stringPoolResTypes = new SparseArray();
                        this.parseStringPool(spBuf, this._headerSize, this._chunkSize, this._stringPoolResTypes, new Utf16ParseStringStrategy());
                        this.tryToFindStringResId();
                        if (this._stringTypeId < 0) {
                            throw new IOException("Could not find string type in resource table.");
                        }
                    }
                    in.read(this._buf2);
                }
                if (AbxUtils.toInt(this._buf2, false) == 1) {
                    ApkUtils.log("String Pool...");
                    in.read(this._buf2);
                    this._headerSize = AbxUtils.toInt(this._buf2, false);
                    in.read(this._buf4);
                    this._chunkSize = AbxUtils.toInt(this._buf4, false);
                    ApkUtils.log("String Pool...Header Size: " + this._headerSize + " Chunk Size: " + this._chunkSize);
                    spBuf = new byte[this._chunkSize - 8];
                    in.read(spBuf);
                    this.parseStringPool(spBuf, this._headerSize, this._chunkSize, this._stringPoolKeys, strategy);
                    in.read(this._buf2);
                }
                while (true) {
                    int res1;
                    int res0;
                    int id;
                    long absoluteOffset = in.getPosition();
                    ApkUtils.log("Absolute byte offset is " + absoluteOffset);
                    ApkUtils.log("Next table type is 0x" + Integer.toHexString(AbxUtils.toInt(this._buf2, false)));
                    if (AbxUtils.toInt(this._buf2, false) == 514) {
                        in.read(this._buf2);
                        this._headerSize = AbxUtils.toInt(this._buf2, false);
                        in.read(this._buf4);
                        this._chunkSize = AbxUtils.toInt(this._buf4, false);
                        ApkUtils.log("Typespec table...Header Size: " + this._headerSize + " Chunk Size: " + this._chunkSize);
                        in.read(this._buf1);
                        id = AbxUtils.toInt(this._buf1, false);
                        in.read(this._buf1);
                        res0 = AbxUtils.toInt(this._buf1, false);
                        in.read(this._buf2);
                        res1 = AbxUtils.toInt(this._buf2, false);
                        in.read(this._buf4);
                        entryCount = AbxUtils.toInt(this._buf4, false);
                        ApkUtils.log("[Typespec] (N/A) id: " + id + " (" + this._stringPoolResTypes.get(id - 1).getValue() + "); res0: " + res0 + "; res1: " + res1 + "; entryCount: " + entryCount);
                        in.skip(this._chunkSize - 8 - 8);
                        in.read(this._buf2);
                        continue;
                    }
                    if (AbxUtils.toInt(this._buf2, false) != 513) break block10;
                    in.read(this._buf2);
                    this._headerSize = AbxUtils.toInt(this._buf2, false);
                    in.read(this._buf4);
                    this._chunkSize = AbxUtils.toInt(this._buf4, false);
                    ApkUtils.log("Type table...Header Size: " + this._headerSize + " Chunk Size: " + this._chunkSize);
                    in.read(this._buf1);
                    id = AbxUtils.toInt(this._buf1, false);
                    in.read(this._buf1);
                    res0 = AbxUtils.toInt(this._buf1, false);
                    in.read(this._buf2);
                    res1 = AbxUtils.toInt(this._buf2, false);
                    in.read(this._buf4);
                    entryCount = AbxUtils.toInt(this._buf4, false);
                    in.read(this._buf4);
                    int entriesStart = AbxUtils.toInt(this._buf4, false);
                    in.read(this._buf4);
                    int resTableConfigSize = AbxUtils.toInt(this._buf4, false);
                    in.skip(resTableConfigSize - 4);
                    ApkUtils.log("[ResTable_type] id: " + id + " (" + this._stringPoolResTypes.get(id - 1).getValue() + "); res0: " + res0 + "; res1: " + res1 + "; entryCount: " + entryCount + "; entriesStart: " + entriesStart + "; resTableConfigSize: " + resTableConfigSize);
                    if (id == this._stringTypeId) break;
                    int bytesToSkip = this._chunkSize - 8 - resTableConfigSize - 12;
                    ApkUtils.log("Skipping table type chunk with ID " + id + " (" + bytesToSkip + " bytes)");
                    long actuallySkippedBytes = in.skip(bytesToSkip);
                    ApkUtils.log("Actually skipped " + actuallySkippedBytes + " bytes");
                    in.read(this._buf2);
                }
                for (i = 0; i < entryCount; ++i) {
                    in.read(this._buf4);
                    int entryOffset = AbxUtils.toInt(this._buf4, false);
                    ApkUtils.log("[ResTable_type] Offset for entry " + i + ": " + entryOffset);
                }
                for (i = 0; i < entryCount; ++i) {
                    in.read(this._buf2);
                    int entryKeyStructSize = AbxUtils.toInt(this._buf2, false);
                    in.read(this._buf2);
                    int flags = AbxUtils.toInt(this._buf2, false);
                    in.read(this._buf4);
                    int stringpoolIndex = AbxUtils.toInt(this._buf4, false);
                    String key = this._stringPoolKeys.get(stringpoolIndex).getValue();
                    ApkUtils.log("[ResTable_entry] key: " + stringpoolIndex + " = " + key + "[size: " + entryKeyStructSize + "]");
                    if ((flags & 1) > 0) {
                        throw new IOException("Complex types are currently not supported.");
                    }
                    in.read(this._buf2);
                    int entryValueStructSize = AbxUtils.toInt(this._buf2, false);
                    in.read(this._buf1);
                    int res0v = AbxUtils.toInt(this._buf1, false);
                    in.read(this._buf1);
                    int dataType = AbxUtils.toInt(this._buf1, false);
                    if (dataType != 3) {
                        ApkUtils.log("[ResTable_entry] Value is not of type string but instead: " + dataType + ". Skipping. [size: " + entryValueStructSize + "]");
                        in.skip(entryValueStructSize - 4);
                        continue;
                    }
                    in.read(this._buf4);
                    int stringpoolValueIndex = AbxUtils.toInt(this._buf4, false);
                    AbxStringPoolEntry value = this._stringPoolValues.get(stringpoolValueIndex);
                    ApkUtils.log("[ResTable_entry] value: " + stringpoolValueIndex + " = " + value);
                    map.put(key, value);
                }
                break block11;
            }
            throw new IOException("Could not find the list of strings in the app's resource table.");
        }
        in.read(this._buf2);
    }

    private void tryToFindStringResId() {
        for (int i = 0; i < this._stringPoolResTypes.size(); ++i) {
            AbxStringPoolEntry entry = this._stringPoolResTypes.valueAt(i);
            ApkUtils.log("Entry: " + entry.getValue() + ": " + entry.getIndex());
            if (!"string".equals(entry.getValue())) continue;
            this._stringTypeId = entry.getIndex() + 1;
            break;
        }
    }
}

