/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository;

import com.android.sdklib.SdkConstants;
import com.android.sdklib.SdkManager;
import com.android.sdklib.internal.repository.Archive;
import com.android.sdklib.internal.repository.ArchiveReplacement;
import com.android.sdklib.internal.repository.ITaskMonitor;
import com.android.sdklib.internal.repository.Package;
import com.android.sdklib.internal.repository.SdkSource;
import com.android.sdklib.internal.repository.UrlOpener;
import com.android.sdklib.io.FileOp;
import com.android.sdklib.io.IFileOp;
import com.android.sdklib.util.GrabProcessOutput;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;

public class ArchiveInstaller {
    public static final String ENV_VAR_IGNORE_COMPAT = "ANDROID_SDK_IGNORE_COMPAT";
    public static final int NUM_MONITOR_INC = 100;
    private final IFileOp mFileOp;

    public ArchiveInstaller() {
        this.mFileOp = new FileOp();
    }

    protected ArchiveInstaller(IFileOp iFileOp) {
        this.mFileOp = iFileOp;
    }

    protected IFileOp getFileOp() {
        return this.mFileOp;
    }

    public boolean install(ArchiveReplacement archiveReplacement, String string, boolean bl, SdkManager sdkManager, ITaskMonitor iTaskMonitor) {
        boolean bl2;
        Archive archive = archiveReplacement.getNewArchive();
        Package package_ = archive.getParentPackage();
        File file = null;
        String string2 = package_.getShortDescription();
        if (archive.isLocal()) {
            iTaskMonitor.log("Skipping already installed archive: %1$s for %2$s", string2, archive.getOsDescription());
            return false;
        }
        boolean bl3 = bl2 = System.getenv(ENV_VAR_IGNORE_COMPAT) == null;
        if (bl2 && !archive.isCompatible()) {
            iTaskMonitor.log("Skipping incompatible archive: %1$s for %2$s", string2, archive.getOsDescription());
            return false;
        }
        file = this.downloadFile(archive, string, iTaskMonitor, bl);
        if (file != null && this.unarchive(archiveReplacement, string, file, sdkManager, iTaskMonitor)) {
            iTaskMonitor.log("Installed %1$s", string2);
            this.mFileOp.deleteFileOrFolder(file);
            return true;
        }
        return false;
    }

    protected File downloadFile(Archive archive, String string, ITaskMonitor iTaskMonitor, boolean bl) {
        File file;
        String string2;
        Object object;
        Object object2;
        String string3 = archive.getParentPackage().getShortDescription();
        iTaskMonitor.setDescription("Downloading %1$s", string3);
        iTaskMonitor.log("Downloading %1$s", string3);
        String string4 = archive.getUrl();
        if (!(string4.startsWith("http://") || string4.startsWith("https://") || string4.startsWith("ftp://"))) {
            Package package_ = archive.getParentPackage();
            object2 = package_.getParentSource();
            if (object2 == null) {
                iTaskMonitor.logError("Internal error: no source for archive %1$s", string3);
                return null;
            }
            object = ((SdkSource)object2).getUrl();
            int n = ((String)object).lastIndexOf(47);
            string2 = ((String)object).substring(0, n + 1);
            string4 = string2 + string4;
        }
        if (bl) {
            string4 = string4.replaceAll("https://", "http://");
        }
        int n = string4.lastIndexOf(47);
        object2 = string4.substring(n + 1);
        object = this.getTempFolder(string);
        if (!this.mFileOp.isDirectory((File)object)) {
            if (this.mFileOp.isFile((File)object)) {
                this.mFileOp.deleteFileOrFolder((File)object);
            }
            if (!this.mFileOp.mkdirs((File)object)) {
                iTaskMonitor.logError("Failed to create directory %1$s", ((File)object).getPath());
                return null;
            }
        }
        if (this.mFileOp.exists(file = new File((File)object, (String)object2))) {
            if (this.mFileOp.length(file) == archive.getSize()) {
                string2 = "";
                try {
                    string2 = this.fileChecksum(archive.getChecksumType().getMessageDigest(), file, iTaskMonitor);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    // empty catch block
                }
                if (string2.equalsIgnoreCase(archive.getChecksum())) {
                    return file;
                }
            }
            this.mFileOp.deleteFileOrFolder(file);
        }
        if (this.fetchUrl(archive, file, string4, string3, iTaskMonitor)) {
            return file;
        }
        this.mFileOp.deleteFileOrFolder(file);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String fileChecksum(MessageDigest messageDigest, File file, ITaskMonitor iTaskMonitor) {
        FileInputStream fileInputStream = null;
        try {
            int n;
            fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[65536];
            while ((n = ((InputStream)fileInputStream).read(byArray)) >= 0) {
                if (n <= 0) continue;
                messageDigest.update(byArray, 0, n);
            }
            String string = this.getDigestChecksum(messageDigest);
            return string;
        }
        catch (FileNotFoundException fileNotFoundException) {
            iTaskMonitor.logError("File not found: %1$s", fileNotFoundException.getMessage());
        }
        catch (Exception exception) {
            iTaskMonitor.logError("%1$s", exception.getMessage());
        }
        finally {
            if (fileInputStream != null) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {}
            }
        }
        return "";
    }

    private String getDigestChecksum(MessageDigest messageDigest) {
        byte[] byArray = messageDigest.digest();
        int n = byArray.length;
        String string = "0123456789abcdef";
        char[] cArray = new char[n * 2];
        for (int i = 0; i < n; ++i) {
            int n2 = byArray[i] & 0xFF;
            cArray[i * 2 + 0] = string.charAt(n2 >>> 4);
            cArray[i * 2 + 1] = string.charAt(n2 & 0xF);
        }
        return new String(cArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean fetchUrl(Archive archive, File file, String string, String string2, ITaskMonitor iTaskMonitor) {
        FileOutputStream fileOutputStream = null;
        InputStream inputStream = null;
        try {
            String string3;
            int n;
            long l;
            inputStream = UrlOpener.openUrl(string, iTaskMonitor);
            fileOutputStream = new FileOutputStream(file);
            MessageDigest messageDigest = archive.getChecksumType().getMessageDigest();
            byte[] byArray = new byte[65536];
            long l2 = 0L;
            long l3 = archive.getSize();
            long l4 = l = l3 / 100L;
            long l5 = System.currentTimeMillis();
            long l6 = l5 + 2000L;
            while ((n = inputStream.read(byArray)) >= 0) {
                if (n > 0) {
                    fileOutputStream.write(byArray, 0, n);
                    messageDigest.update(byArray, 0, n);
                }
                long l7 = System.currentTimeMillis();
                if ((l2 += (long)n) >= l4) {
                    iTaskMonitor.incProgress(1);
                    l4 += l;
                }
                if (l7 > l6) {
                    long l8 = l7 - l5;
                    if (l2 > 0L && l8 > 0L) {
                        int n2 = (int)(100L * l2 / l3);
                        float f = (float)l2 / (float)l8 * 0.9765625f;
                        int n3 = (double)f > 0.001 ? (int)((float)(l3 - l2) / 1024.0f / f) : 0;
                        String string4 = "seconds";
                        if (n3 > 120) {
                            string4 = "minutes";
                            n3 /= 60;
                        }
                        iTaskMonitor.setDescription("Downloading %1$s (%2$d%%, %3$.0f KiB/s, %4$d %5$s left)", string2, n2, Float.valueOf(f), n3, string4);
                    }
                    l6 = l7 + 1000L;
                }
                if (!iTaskMonitor.isCancelRequested()) continue;
                iTaskMonitor.log("Download aborted by user at %1$d bytes.", l2);
                boolean bl = false;
                return bl;
            }
            if (l2 != l3) {
                iTaskMonitor.logError("Download finished with wrong size. Expected %1$d bytes, got %2$d bytes.", l3, l2);
                boolean bl = false;
                return bl;
            }
            String string5 = this.getDigestChecksum(messageDigest);
            if (!string5.equalsIgnoreCase(string3 = archive.getChecksum())) {
                iTaskMonitor.logError("Download finished with wrong checksum. Expected %1$s, got %2$s.", string3, string5);
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException fileNotFoundException) {
            iTaskMonitor.logError("File not found: %1$s", fileNotFoundException.getMessage());
            return false;
        }
        catch (Exception exception) {
            iTaskMonitor.logError("%1$s", exception.getMessage());
            return false;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean unarchive(ArchiveReplacement archiveReplacement, String string, File file, SdkManager sdkManager, ITaskMonitor iTaskMonitor) {
        boolean bl;
        File file2;
        block38: {
            Package package_;
            Archive archive;
            block39: {
                File file3;
                boolean bl2;
                block35: {
                    boolean bl3;
                    block36: {
                        block37: {
                            block32: {
                                block33: {
                                    block34: {
                                        block29: {
                                            block30: {
                                                block31: {
                                                    block23: {
                                                        boolean bl4;
                                                        block24: {
                                                            boolean bl5;
                                                            block25: {
                                                                block26: {
                                                                    String string2;
                                                                    block20: {
                                                                        boolean bl6;
                                                                        block21: {
                                                                            block22: {
                                                                                String string3;
                                                                                block17: {
                                                                                    boolean bl7;
                                                                                    block18: {
                                                                                        block19: {
                                                                                            bl2 = false;
                                                                                            archive = archiveReplacement.getNewArchive();
                                                                                            package_ = archive.getParentPackage();
                                                                                            string3 = package_.getShortDescription();
                                                                                            iTaskMonitor.setDescription("Installing %1$s", string3);
                                                                                            iTaskMonitor.log("Installing %1$s", string3);
                                                                                            string2 = package_.getClass().getSimpleName();
                                                                                            file3 = null;
                                                                                            file2 = null;
                                                                                            file3 = package_.getInstallFolder(string, sdkManager);
                                                                                            if (file3 != null) break block17;
                                                                                            iTaskMonitor.log("Failed to compute installation directory for %1$s.", string3);
                                                                                            bl7 = false;
                                                                                            if (bl2) break block18;
                                                                                            if (file2 == null) break block19;
                                                                                            this.restoreFolder(file2, file3);
                                                                                        }
                                                                                        package_.postInstallHook(archive, iTaskMonitor, null);
                                                                                    }
                                                                                    this.mFileOp.deleteFileOrFolder(file2);
                                                                                    return bl7;
                                                                                }
                                                                                if (package_.preInstallHook(archive, iTaskMonitor, string, file3)) break block20;
                                                                                iTaskMonitor.log("Skipping archive: %1$s", string3);
                                                                                bl6 = false;
                                                                                if (bl2) break block21;
                                                                                if (file2 == null) break block22;
                                                                                this.restoreFolder(file2, file3);
                                                                            }
                                                                            package_.postInstallHook(archive, iTaskMonitor, null);
                                                                        }
                                                                        this.mFileOp.deleteFileOrFolder(file2);
                                                                        return bl6;
                                                                    }
                                                                    if (!this.mFileOp.exists(file3)) break block23;
                                                                    if (file2 == null) {
                                                                        file2 = this.getNewTempFolder(string, string2, "old");
                                                                    }
                                                                    if (file2 != null) break block24;
                                                                    iTaskMonitor.logError("Failed to find a temp directory in %1$s.", string);
                                                                    bl5 = false;
                                                                    if (bl2) break block25;
                                                                    if (file2 == null) break block26;
                                                                    this.restoreFolder(file2, file3);
                                                                }
                                                                package_.postInstallHook(archive, iTaskMonitor, null);
                                                            }
                                                            this.mFileOp.deleteFileOrFolder(file2);
                                                            return bl5;
                                                        }
                                                        try {
                                                            while (!this.moveFolder(file3, file2)) {
                                                                iTaskMonitor.logError("Failed to rename directory %1$s to %2$s.", file3.getPath(), file2.getPath());
                                                                if (SdkConstants.CURRENT_PLATFORM != 2) break;
                                                                bl3 = true;
                                                                bl3 = this.windowsDestDirLocked(string, file3, iTaskMonitor);
                                                                if (bl3) continue;
                                                                bl4 = false;
                                                                if (bl2) break block27;
                                                                if (file2 == null) break block28;
                                                                this.restoreFolder(file2, file3);
                                                            }
                                                        }
                                                        catch (Throwable throwable) {
                                                            if (!bl2) {
                                                                if (file2 != null) {
                                                                    this.restoreFolder(file2, file3);
                                                                }
                                                                package_.postInstallHook(archive, iTaskMonitor, null);
                                                            }
                                                            this.mFileOp.deleteFileOrFolder(file2);
                                                            throw throwable;
                                                        }
                                                        {
                                                            block27: {
                                                                block28: {
                                                                }
                                                                package_.postInstallHook(archive, iTaskMonitor, null);
                                                            }
                                                            this.mFileOp.deleteFileOrFolder(file2);
                                                            return bl4;
                                                        }
                                                    }
                                                    assert (!this.mFileOp.exists(file3));
                                                    if (this.mFileOp.mkdirs(file3)) break block29;
                                                    iTaskMonitor.logError("Failed to create directory %1$s", file3.getPath());
                                                    bl3 = false;
                                                    if (bl2) break block30;
                                                    if (file2 == null) break block31;
                                                    this.restoreFolder(file2, file3);
                                                }
                                                package_.postInstallHook(archive, iTaskMonitor, null);
                                            }
                                            this.mFileOp.deleteFileOrFolder(file2);
                                            return bl3;
                                        }
                                        if (this.unzipFolder(archiveReplacement, file, file3, iTaskMonitor)) break block32;
                                        bl3 = false;
                                        if (bl2) break block33;
                                        if (file2 == null) break block34;
                                        this.restoreFolder(file2, file3);
                                    }
                                    package_.postInstallHook(archive, iTaskMonitor, null);
                                }
                                this.mFileOp.deleteFileOrFolder(file2);
                                return bl3;
                            }
                            if (this.generateSourceProperties(archive, file3)) break block35;
                            iTaskMonitor.logError("Failed to generate source.properties in directory %1$s", file3.getPath());
                            bl3 = false;
                            if (bl2) break block36;
                            if (file2 == null) break block37;
                            this.restoreFolder(file2, file3);
                        }
                        package_.postInstallHook(archive, iTaskMonitor, null);
                    }
                    this.mFileOp.deleteFileOrFolder(file2);
                    return bl3;
                }
                Archive archive2 = archiveReplacement.getReplaced();
                if (archive2 != null && archive2.isLocal()) {
                    File file4;
                    String string4 = archive2.getLocalOsPath();
                    File file5 = file4 = string4 == null ? null : new File(string4);
                    if (file4 == null && archive2.getParentPackage() != null) {
                        file4 = archive2.getParentPackage().getInstallFolder(string, sdkManager);
                    }
                    if (file4 != null && this.mFileOp.exists(file4) && !file4.equals(file3)) {
                        iTaskMonitor.logVerbose("Removing old archive at %1$s", file4.getAbsolutePath());
                        this.mFileOp.deleteFileOrFolder(file4);
                    }
                }
                bl2 = true;
                package_.postInstallHook(archive, iTaskMonitor, file3);
                bl = true;
                if (bl2) break block38;
                if (file2 == null) break block39;
                this.restoreFolder(file2, file3);
            }
            package_.postInstallHook(archive, iTaskMonitor, null);
        }
        this.mFileOp.deleteFileOrFolder(file2);
        return bl;
    }

    private boolean windowsDestDirLocked(String string, File file, final ITaskMonitor iTaskMonitor) {
        String string2 = null;
        assert (SdkConstants.CURRENT_PLATFORM == 2);
        File file2 = FileOp.append(string, "tools", "lib", SdkConstants.FN_FIND_LOCK);
        if (this.mFileOp.exists(file2)) {
            try {
                final StringBuilder stringBuilder = new StringBuilder();
                String[] stringArray = new String[]{file2.getAbsolutePath(), file.getAbsolutePath()};
                Process process = Runtime.getRuntime().exec(stringArray);
                int n = GrabProcessOutput.grabProcessOutput(process, GrabProcessOutput.Wait.WAIT_FOR_READERS, new GrabProcessOutput.IProcessOutput(){

                    public void out(String string) {
                        if (string != null) {
                            stringBuilder.append(string).append("\n");
                        }
                    }

                    public void err(String string) {
                        if (string != null) {
                            iTaskMonitor.logError("[find_lock] Error: %1$s", string);
                        }
                    }
                });
                if (n == 0 && stringBuilder.length() > 0) {
                    String string3 = stringBuilder.toString().trim();
                    iTaskMonitor.logError("[find_lock] Directory locked by %1$s", string3);
                    TreeSet<String> treeSet = new TreeSet<String>(Arrays.asList(string3.split(Pattern.quote(";"))));
                    StringBuilder stringBuilder2 = new StringBuilder();
                    for (String string4 : treeSet) {
                        stringBuilder2.append("\n  - ").append(string4.trim());
                    }
                    string2 = String.format("-= Warning ! =-\nThe following processes: %1$s\nare locking the following directory: \n  %2$s\nPlease close these applications so that the installation can continue.\nWhen ready, press YES to try again.", stringBuilder2.toString(), file.getPath());
                }
            }
            catch (Exception exception) {
                iTaskMonitor.error(exception, "[find_lock failed]", new Object[0]);
            }
        }
        if (string2 == null) {
            string2 = String.format("-= Warning ! =-\nA folder failed to be moved. On Windows this typically means that a program is using that folder (for example Windows Explorer or your anti-virus software.)\nPlease momentarily deactivate your anti-virus software or close any running programs that may be accessing the directory '%1$s'.\nWhen ready, press YES to try again.", file.getPath());
        }
        boolean bl = iTaskMonitor.displayPrompt("SDK Manager: failed to install", string2);
        return bl;
    }

    private boolean moveFolder(File file, File file2) {
        for (int i = 0; i < 5; ++i) {
            if (this.mFileOp.renameTo(file, file2)) {
                return true;
            }
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean unzipFolder(ArchiveReplacement archiveReplacement, File file, File file2, ITaskMonitor iTaskMonitor) {
        Archive archive = archiveReplacement.getNewArchive();
        Package package_ = archive.getParentPackage();
        String string = package_.getShortDescription();
        long l = archive.getSize();
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
            long l2 = l / 100L;
            long l3 = 0L;
            long l4 = 0L;
            int n = 0;
            byte[] byArray = new byte[65536];
            Enumeration enumeration = zipFile.getEntries();
            while (enumeration.hasMoreElements()) {
                long l5;
                boolean bl;
                Object object;
                ZipArchiveEntry zipArchiveEntry = (ZipArchiveEntry)enumeration.nextElement();
                String string2 = zipArchiveEntry.getName();
                int n2 = (string2 = string2.replace('\\', '/')).indexOf(47);
                if (n2 < 0 || n2 == string2.length() - 1) continue;
                string2 = string2.substring(n2 + 1);
                File file3 = new File(file2, string2);
                if (string2.endsWith("/")) {
                    if (this.mFileOp.isDirectory(file3) || this.mFileOp.mkdirs(file3)) continue;
                    iTaskMonitor.logError("Failed to create directory %1$s", file3.getPath());
                    boolean bl2 = false;
                    return bl2;
                }
                if (string2.indexOf(47) != -1 && !this.mFileOp.isDirectory((File)(object = file3.getParentFile())) && !this.mFileOp.mkdirs((File)object)) {
                    iTaskMonitor.logError("Failed to create directory %1$s", ((File)object).getPath());
                    boolean bl3 = false;
                    return bl3;
                }
                object = null;
                try {
                    object = new FileOutputStream(file3);
                    InputStream inputStream = zipFile.getInputStream(zipArchiveEntry);
                    for (l5 = zipArchiveEntry.getSize(); l5 > 0L && !(bl = inputStream.read(byArray, 0, (int)Math.min(l5, (long)byArray.length))); l5 -= (long)bl) {
                        if (bl <= false) continue;
                        ((FileOutputStream)object).write(byArray, 0, bl ? 1 : 0);
                    }
                }
                catch (EOFException eOFException) {
                    iTaskMonitor.logError("Error uncompressing file %s. Size: %d bytes, Unwritten: %d bytes.", zipArchiveEntry.getName(), zipArchiveEntry.getSize(), l5);
                    throw eOFException;
                }
                finally {
                    if (object != null) {
                        ((FileOutputStream)object).close();
                    }
                }
                package_.postUnzipFileHook(archive, iTaskMonitor, this.mFileOp, file3, zipArchiveEntry);
                l3 += zipArchiveEntry.getCompressedSize();
                while (l4 < l3) {
                    iTaskMonitor.incProgress(1);
                    l4 += l2;
                }
                int n3 = (int)(100L * l3 / l);
                if (n3 != n) {
                    iTaskMonitor.setDescription("Unzipping %1$s (%2$d%%)", string, n3);
                    n = n3;
                }
                if (!iTaskMonitor.isCancelRequested()) continue;
                bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            iTaskMonitor.logError("Unzip failed: %1$s", iOException.getMessage());
            return false;
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private File getNewTempFolder(String string, String string2, String string3) {
        File file = this.getTempFolder(string);
        if (!this.mFileOp.isDirectory(file)) {
            if (this.mFileOp.isFile(file)) {
                this.mFileOp.deleteFileOrFolder(file);
            }
            if (!this.mFileOp.mkdirs(file)) {
                return null;
            }
        }
        for (int i = 1; i < 100; ++i) {
            File file2 = new File(file, String.format("%1$s.%2$s%3$02d", string2, string3, i));
            if (this.mFileOp.exists(file2)) continue;
            return file2;
        }
        return null;
    }

    private File getTempFolder(String string) {
        File file = new File(string, "temp");
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean generateSourceProperties(Archive archive, File file) {
        Properties properties = new Properties();
        archive.saveProperties(properties);
        Package package_ = archive.getParentPackage();
        if (package_ != null) {
            package_.saveProperties(properties);
        }
        OutputStream outputStream = null;
        try {
            File file2 = new File(file, "source.properties");
            outputStream = this.mFileOp.newFileOutputStream(file2);
            properties.store(outputStream, "## Android Tool: Source of this archive.");
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    private boolean restoreFolder(File file, File file2) {
        File file3;
        boolean bl = true;
        File[] fileArray = this.mFileOp.listFiles(file);
        if (fileArray == null) {
            return false;
        }
        if (this.mFileOp.isFile(file2)) {
            if (!this.mFileOp.delete(file2)) {
                return false;
            }
        } else if (!this.mFileOp.isDirectory(file2)) {
            this.mFileOp.mkdirs(file2);
        }
        HashSet<File> hashSet = new HashSet<File>();
        HashSet<File> hashSet2 = new HashSet<File>();
        File[] fileArray2 = this.mFileOp.listFiles(file2);
        if (fileArray2 != null) {
            for (File object : fileArray2) {
                if (this.mFileOp.isDirectory(object)) {
                    hashSet.add(object);
                    continue;
                }
                hashSet2.add(object);
            }
        }
        for (File file4 : fileArray) {
            if (!this.mFileOp.isDirectory(file4)) continue;
            file3 = new File(file2, file4.getName());
            hashSet.remove(file3);
            if (this.restoreFolder(file4, file3)) continue;
            bl = false;
        }
        for (File file4 : hashSet) {
            this.mFileOp.deleteFileOrFolder(file4);
        }
        for (File file5 : fileArray) {
            if (!this.mFileOp.isFile(file5)) continue;
            file3 = new File(file2, file5.getName());
            hashSet2.remove(file3);
            try {
                this.mFileOp.copyFile(file5, file3);
            }
            catch (IOException iOException) {
                bl = false;
            }
        }
        for (File file5 : hashSet2) {
            this.mFileOp.deleteFileOrFolder(file5);
        }
        return bl;
    }
}

