/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository;

import com.android.sdklib.SdkConstants;
import com.android.sdklib.SdkManager;
import com.android.sdklib.internal.repository.Archive;
import com.android.sdklib.internal.repository.IMinPlatformToolsDependency;
import com.android.sdklib.internal.repository.ITaskMonitor;
import com.android.sdklib.internal.repository.Package;
import com.android.sdklib.internal.repository.SdkSource;
import com.android.sdklib.internal.repository.XmlParserUtils;
import com.android.sdklib.util.GrabProcessOutput;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolPackage
extends Package
implements IMinPlatformToolsDependency {
    public static final String INSTALL_ID = "tools";
    protected static final String PROP_MIN_PLATFORM_TOOLS_REV = "Platform.MinPlatformToolsRev";
    private final int mMinPlatformToolsRevision;

    ToolPackage(SdkSource sdkSource, Node node, String string, Map<String, String> map) {
        super(sdkSource, node, string, map);
        this.mMinPlatformToolsRevision = XmlParserUtils.getXmlInt(node, "min-platform-tools-rev", 0);
        if (this.mMinPlatformToolsRevision == 0) {
            boolean bl = false;
            Pattern pattern = Pattern.compile("http://schemas.android.com/sdk/android/repository/([1-9][0-9]*)");
            Matcher matcher = pattern.matcher(string);
            if (matcher.matches()) {
                String string2 = matcher.group(1);
                try {
                    bl = Integer.parseInt(string2) >= 3;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (bl) {
                throw new IllegalArgumentException(String.format("Missing %1$s element in %2$s package", "min-platform-tools-rev", "platform-tool"));
            }
        }
    }

    static Package create(SdkSource sdkSource, Properties properties, int n, String string, String string2, String string3, Archive.Os os, Archive.Arch arch, String string4) {
        return new ToolPackage(sdkSource, properties, n, string, string2, string3, os, arch, string4);
    }

    protected ToolPackage(SdkSource sdkSource, Properties properties, int n, String string, String string2, String string3, Archive.Os os, Archive.Arch arch, String string4) {
        super(sdkSource, properties, n, string, string2, string3, os, arch, string4);
        this.mMinPlatformToolsRevision = Integer.parseInt(ToolPackage.getProperty(properties, PROP_MIN_PLATFORM_TOOLS_REV, Integer.toString(0)));
    }

    @Override
    public int getMinPlatformToolsRevision() {
        return this.mMinPlatformToolsRevision;
    }

    @Override
    public String installId() {
        return INSTALL_ID;
    }

    @Override
    public String getListDescription() {
        return String.format("Android SDK Tools%1$s", this.isObsolete() ? " (Obsolete)" : "");
    }

    @Override
    public String getShortDescription() {
        return String.format("Android SDK Tools, revision %1$d%2$s", this.getRevision(), this.isObsolete() ? " (Obsolete)" : "");
    }

    @Override
    public String getLongDescription() {
        String string = this.getDescription();
        if (string == null || string.length() == 0) {
            string = this.getShortDescription();
        }
        if (string.indexOf("revision") == -1) {
            string = string + String.format("\nRevision %1$d%2$s", this.getRevision(), this.isObsolete() ? " (Obsolete)" : "");
        }
        return string;
    }

    @Override
    public File getInstallFolder(String string, SdkManager sdkManager) {
        return new File(string, INSTALL_ID);
    }

    @Override
    public boolean sameItemAs(Package package_) {
        return package_ instanceof ToolPackage;
    }

    @Override
    void saveProperties(Properties properties) {
        super.saveProperties(properties);
        if (this.getMinPlatformToolsRevision() != 0) {
            properties.setProperty(PROP_MIN_PLATFORM_TOOLS_REV, Integer.toString(this.getMinPlatformToolsRevision()));
        }
    }

    @Override
    public void postInstallHook(Archive archive, final ITaskMonitor iTaskMonitor, File file) {
        super.postInstallHook(archive, iTaskMonitor, file);
        if (file == null) {
            return;
        }
        File file2 = new File(file, "lib");
        if (!file2.isDirectory()) {
            return;
        }
        String string = "post_tools_install";
        String string2 = "";
        if (SdkConstants.currentPlatform() == 2) {
            string2 = "cmd.exe /c ";
            string = string + ".bat";
        } else {
            string = string + ".sh";
        }
        File file3 = new File(file2, string);
        if (!file3.isFile()) {
            return;
        }
        int n = -1;
        try {
            Process process = Runtime.getRuntime().exec(string2 + string, null, file2);
            final String string3 = string;
            n = GrabProcessOutput.grabProcessOutput(process, GrabProcessOutput.Wait.WAIT_FOR_PROCESS, new GrabProcessOutput.IProcessOutput(){

                public void out(String string) {
                    if (string != null) {
                        iTaskMonitor.log("[%1$s] %2$s", string3, string);
                    }
                }

                public void err(String string) {
                    if (string != null) {
                        iTaskMonitor.logError("[%1$s] Error: %2$s", string3, string);
                    }
                }
            });
        }
        catch (Exception exception) {
            iTaskMonitor.logError("Exception: %s", exception.toString());
        }
        if (n != 0) {
            iTaskMonitor.logError("Failed to execute %s", string);
            return;
        }
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + this.mMinPlatformToolsRevision;
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof ToolPackage)) {
            return false;
        }
        ToolPackage toolPackage = (ToolPackage)object;
        return this.mMinPlatformToolsRevision == toolPackage.mMinPlatformToolsRevision;
    }
}

