/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.api;

import org.json.simple.JSONObject;

public class Software {
    public static final String JSON_NAME = "name";
    public static final String JSON_BUNDLE_ID = "bundle_identifier";
    public static final String JSON_PLATFORM = "platform";
    public static final String JSON_LATEST = "latest";
    public static final String JSON_LATEST_VERSION = "latest_version";
    public static final String JSON_DOWNLOAD_URL = "download_url";
    public static final String JSON_RELEASE_NOTES = "release_notes";
    private final String _name;
    private final String _bundleId;
    private final String _platform;
    private final String _latestVersion;
    private final String _downloadUrl;
    private final String _releaseNotes;

    public static Software createFromJSON(JSONObject json) {
        String name = (String)json.get(JSON_NAME);
        String bundleId = (String)json.get(JSON_BUNDLE_ID);
        String platform = (String)json.get(JSON_PLATFORM);
        String latestVersion = (String)json.get(JSON_LATEST_VERSION);
        JSONObject latest = (JSONObject)json.get(JSON_LATEST);
        String downloadUrl = (String)latest.get(JSON_DOWNLOAD_URL);
        String releaseNotes = (String)latest.get(JSON_RELEASE_NOTES);
        return new Software(name, bundleId, platform, latestVersion, downloadUrl, releaseNotes);
    }

    public Software(String name, String bundleId, String platform, String latestVersion, String downloadUrl, String releaseNotes) {
        this._name = name;
        this._bundleId = bundleId;
        this._platform = platform;
        this._latestVersion = latestVersion;
        this._downloadUrl = downloadUrl;
        this._releaseNotes = releaseNotes;
    }

    public String getName() {
        return this._name;
    }

    public String getBundleId() {
        return this._bundleId;
    }

    public String getPlatform() {
        return this._platform;
    }

    public String getLatestVersion() {
        return this._latestVersion;
    }

    public String getDownloadUrl() {
        return this._downloadUrl;
    }

    public String getReleaseNotes() {
        return this._releaseNotes;
    }

    public String toString() {
        return this._name + " (" + this._bundleId + " " + this._latestVersion + ")";
    }
}

