/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.api;

import com.crashlytics.api.net.auth.OAuthClient;

public class User {
    private final String _email;
    private final String _name;
    private final TokenWrapper<?> _token;

    public static User create(String email, String name, OAuthClient.Token token) {
        if (email == null || name == null || token == null) {
            return null;
        }
        return new User(email, name, token);
    }

    public static User create(String email, String name, String token) {
        if (email == null || name == null || token == null) {
            return null;
        }
        return new User(email, name, token);
    }

    private User(String email, String name, String token) {
        if (email.isEmpty() || token.isEmpty()) {
            throw new IllegalArgumentException("Unexpected empty value: " + email + ", " + token);
        }
        this._email = email;
        this._name = name;
        this._token = new TokenWrapper<String>(token);
    }

    private User(String email, String name, OAuthClient.Token token) {
        if (email.isEmpty()) {
            throw new IllegalArgumentException("Unexpected empty value: " + email);
        }
        this._email = email;
        this._name = name;
        this._token = new TokenWrapper<OAuthClient.Token>(token);
    }

    public String getEmail() {
        return this._email;
    }

    public String getName() {
        return this._name;
    }

    public TokenWrapper<?> getToken() {
        return this._token;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._email == null ? 0 : this._email.hashCode());
        result = 31 * result + (this._name == null ? 0 : this._name.hashCode());
        result = 31 * result + (this._token == null ? 0 : this._token.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        User other = (User)obj;
        return this._email.equals(other._email) && this._token.equals(other._token);
    }

    public String toString() {
        return this._email;
    }

    public class TokenWrapper<T> {
        public T token;

        public TokenWrapper(T token) {
            this.token = token;
        }
    }
}

