/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.api.net.auth;

import com.crashlytics.tools.android.DeveloperTools;
import com.google.common.base.Joiner;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public final class OAuthClient {
    private static final String TOKEN_ENDPOINT = "/oauth/token?grant_type=password";
    private static final String REFRESH_TOKEN_ENDPOINT = "/oauth/token?grant_type=refresh_token";
    private static final String USERNAME_QUERY = "&username=";
    private static final String PASSWORD_QUERY = "&password=";
    private static final String REFRESH_TOKEN_QUERY = "&refresh_token=";
    private static final String DEFAULT_SCOPE_QUERY = "&scope=" + Joiner.on("%20").join("organizations", "apps", "issues");
    private static final String UTF8 = "UTF-8";
    private final URI _baseUri;

    public OAuthClient(URI baseUri) {
        this._baseUri = baseUri;
    }

    public URI getBaseUrl() {
        return this._baseUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Token getToken(HttpClient client, String username, String password) {
        block8: {
            InputStream stream = null;
            try {
                HttpPost post = new HttpPost(new URI(this._baseUri + TOKEN_ENDPOINT + DEFAULT_SCOPE_QUERY));
                post.setEntity(new StringEntity(USERNAME_QUERY + username + PASSWORD_QUERY + password));
                stream = OAuthClient.fetch(client, post);
                if (stream != null) {
                    Token token = OAuthClient.parse(stream);
                    IOUtils.closeQuietly(stream);
                    return token;
                }
                IOUtils.closeQuietly(stream);
            }
            catch (URISyntaxException e) {
                DeveloperTools.logE("Crashlytics encountered a bad URI", e);
            }
            catch (UnsupportedEncodingException e2) {
                DeveloperTools.logE("Crashlytics doesn't support this encoding", e2);
                break block8;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IOUtils.closeQuietly(stream);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Token refreshToken(HttpClient client, Token token) {
        InputStream stream;
        block9: {
            Token token2;
            block8: {
                if (token == null) {
                    return null;
                }
                stream = null;
                try {
                    HttpPost post = new HttpPost(new URI(this._baseUri + REFRESH_TOKEN_ENDPOINT + REFRESH_TOKEN_QUERY + token.getRefreshToken()));
                    stream = OAuthClient.fetch(client, post);
                    if (stream != null) {
                        token2 = OAuthClient.parse(stream);
                        if (stream == null) return token2;
                        break block8;
                    }
                    if (stream == null) return null;
                    break block9;
                }
                catch (URISyntaxException e) {
                    DeveloperTools.logE("Crashlytics encountered a bad URI", e);
                    return null;
                }
            }
            IOUtils.closeQuietly(stream);
            return token2;
        }
        IOUtils.closeQuietly(stream);
        return null;
        finally {
            if (stream != null) {
                IOUtils.closeQuietly(stream);
            }
        }
    }

    private static InputStream fetch(HttpClient client, HttpPost post) {
        try {
            post.addHeader("Content-Type", "application/x-www-form-urlencoded");
            post.addHeader("Accept", "application/json");
            DeveloperTools.logD("REQUEST: " + post.getURI());
            HttpResponse response = client.execute(post);
            Header requestIdHeader = response.getFirstHeader("X-Request-Id");
            String requestId = requestIdHeader == null ? "null" : requestIdHeader.getValue();
            DeveloperTools.logD("RESPONSE: " + response.getStatusLine().getStatusCode() + " [reqId=" + requestId + "]");
            if (response.getStatusLine().getStatusCode() != 200) {
                return null;
            }
            return response.getEntity().getContent();
        }
        catch (ClientProtocolException e) {
            DeveloperTools.logE("Crashlytics encountered a client protocol exception", e);
        }
        catch (IOException e) {
            DeveloperTools.logE("Crashlytics encountered an IO exception", e);
        }
        return null;
    }

    public static HttpRequestBase sign(HttpRequestBase request, Token token) {
        request.setHeader("Authorization", "Bearer " + token.getAccessToken());
        return request;
    }

    private static Token parse(InputStream stream) {
        try {
            JSONParser parser = new JSONParser();
            JSONObject parsed = (JSONObject)parser.parse(new InputStreamReader(stream, Charset.forName(UTF8)));
            return new Token((String)parsed.get("access_token"), (String)parsed.get("refresh_token"), (String)parsed.get("token_type"), (Long)parsed.get("expires_in"));
        }
        catch (ParseException e) {
            DeveloperTools.logE("Crashlytics couldn't extract the token", e);
        }
        catch (IOException e) {
            DeveloperTools.logE("Crashlytics couldn't extract the token", e);
        }
        return null;
    }

    public static final class Token {
        private final String _accessToken;
        private final String _refreshToken;
        private final String _tokenType;
        private final long _expiresIn;

        public Token(String accessToken, String refreshToken, String tokenType, long expiresIn) {
            this._accessToken = accessToken;
            this._refreshToken = refreshToken;
            this._tokenType = tokenType;
            this._expiresIn = expiresIn;
        }

        public String getAccessToken() {
            return this._accessToken;
        }

        public String getRefreshToken() {
            return this._refreshToken;
        }

        public String toString() {
            return "{ accessToken=" + this._accessToken + ", refreshToken=" + this._refreshToken + ", tokenType=" + this._tokenType + ", expiresIn=" + this._expiresIn + " }";
        }
    }
}

