/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.api.net.proxy;

import java.net.URL;
import org.apache.http.client.methods.HttpRequestBase;

public enum ProtocolScheme {
    HTTP("http.proxyHost", "http.proxyUser", "http.proxyPassword", "http.proxyPort"),
    HTTPS("https.proxyHost", "https.proxyUser", "https.proxyPassword", "https.proxyPort"),
    Other(null, null, null, null);

    private String _proxyHostProp;
    private String _proxyUserProp;
    private String _proxyPasswordProp;
    private String _proxyPortProp;

    private ProtocolScheme(String hostProp, String userProp, String passwordProp, String portProp) {
        this._proxyHostProp = hostProp;
        this._proxyUserProp = userProp;
        this._proxyPasswordProp = passwordProp;
        this._proxyPortProp = portProp;
    }

    public static ProtocolScheme getType(HttpRequestBase request) {
        return ProtocolScheme.getType(request.getURI().getScheme());
    }

    public static ProtocolScheme getType(URL url) {
        return ProtocolScheme.getType(url.getProtocol());
    }

    public static ProtocolScheme getType(String protocolString) {
        if (protocolString.equalsIgnoreCase("HTTP")) {
            return HTTP;
        }
        if (protocolString.equalsIgnoreCase("HTTPS")) {
            return HTTPS;
        }
        return Other;
    }

    public String getHost() {
        return this._proxyHostProp == null ? null : System.getProperty(this._proxyHostProp);
    }

    public String getUser() {
        return this._proxyUserProp == null ? null : System.getProperty(this._proxyUserProp);
    }

    public String getPassword() {
        return this._proxyPasswordProp == null ? null : System.getProperty(this._proxyPasswordProp);
    }

    public String getPort() {
        return this._proxyPortProp == null ? null : System.getProperty(this._proxyPortProp);
    }
}

