/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.api.ota;

import com.crashlytics.api.ota.Device;
import com.crashlytics.api.ota.DistributionSelectableItem;
import com.crashlytics.api.ota.PersonEvent;
import com.crashlytics.api.ota.PersonGroup;
import com.crashlytics.api.ota.PersonInvitation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class Person
implements DistributionSelectableItem {
    private static final String ACCEPTED = "accepted";
    private static final String ENABLED = "enabled";
    public final String testerId;
    public final String emailStatus;
    public final String invitationId;
    public final Date overallStatusModifiedAt;
    public final String email;
    public final List<PersonEvent> events;
    public final String name;
    public final String overallStatus;
    public final List<Device> devices;
    public final PersonInvitation invitation;
    public final List<PersonGroup> groups;
    private String _access;
    private boolean _selected;
    private Set<PersonGroup> _lockedByGroups = new LinkedHashSet<PersonGroup>();

    public Person(String email) {
        this(null, null, null, null, email, Collections.emptyList(), "", null, Collections.emptyList(), null, ENABLED, Collections.emptyList());
    }

    public Person(String firstName, String lastName, String email) {
        this(null, null, null, null, email, Collections.emptyList(), firstName + " " + lastName, null, Collections.emptyList(), null, ENABLED, Collections.emptyList());
    }

    public Person(String testerId, String emailStatus, String invitationId, Date overallStatusModifiedAt, String email, List<PersonEvent> events, String name, String overallStatus, List<Device> devices, PersonInvitation invitation, String access, List<PersonGroup> groups) {
        this.testerId = testerId;
        this.emailStatus = emailStatus;
        this.invitationId = invitationId;
        this.overallStatusModifiedAt = overallStatusModifiedAt;
        this.email = email;
        this.events = Collections.unmodifiableList(new ArrayList<PersonEvent>(events));
        this.name = name;
        this.overallStatus = overallStatus;
        this.devices = Collections.unmodifiableList(new ArrayList<Device>(devices));
        this.invitation = invitation;
        this.groups = groups;
        this._access = access;
        this._selected = this.isAccessEnabled();
    }

    @Override
    public String getIdentifier() {
        return this.isTester() ? this.testerId : this.email;
    }

    public void addLockedByGroup(PersonGroup group) {
        if (group == null) {
            throw new NullPointerException("group must not be null");
        }
        this._lockedByGroups.add(group);
    }

    public void removeLockedByGroup(PersonGroup group) {
        if (group == null) {
            throw new NullPointerException("group must not be null");
        }
        this._lockedByGroups.remove(group);
    }

    @Override
    public boolean isExpandable() {
        return !this.devices.isEmpty() || !this.groups.isEmpty();
    }

    public boolean isLocked() {
        return !this._lockedByGroups.isEmpty();
    }

    @Override
    public boolean isSelected() {
        return this._selected || this.isLocked();
    }

    public void setSelected(boolean selected) {
        this._selected = selected;
    }

    public String getAccess() {
        return this._access;
    }

    public void setAccess(String access) {
        if (access == null) {
            throw new NullPointerException("access must not be null");
        }
        this._access = access;
    }

    @Override
    public boolean isTester() {
        return this.testerId != null;
    }

    @Override
    public boolean isGroup() {
        return false;
    }

    public boolean isAccessEnabled() {
        return ENABLED.equals(this._access);
    }

    public boolean isStatusAccepted() {
        return ACCEPTED.equals(this.overallStatus);
    }

    String getNameForComparison() {
        return this.name == null ? "" : this.name.toLowerCase();
    }

    String getEmailForComparison() {
        return this.email == null ? "" : this.email.toLowerCase();
    }
}

