/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.api.ota;

import com.crashlytics.api.ota.PersonGroup;
import org.json.simple.JSONObject;

public class PersonGroupJsonTransform {
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String ACCESS = "access";
    private static final String TESTER_COUNT = "tester_count";
    private static final String RELEASE_TESTER_COUNT = "release_tester_count";

    public PersonGroup createGroupFrom(JSONObject groupJson) {
        if (groupJson == null) {
            return null;
        }
        String id = (String)groupJson.get(ID);
        String name = (String)groupJson.get(NAME);
        return new PersonGroup(id, name);
    }

    public PersonGroup createGroupForReleaseFrom(JSONObject groupJson) {
        if (groupJson == null) {
            return null;
        }
        String id = (String)groupJson.get(ID);
        String name = (String)groupJson.get(NAME);
        String access = (String)groupJson.get(ACCESS);
        int testerCount = ((Long)groupJson.get(TESTER_COUNT)).intValue();
        int releaseTesterCount = ((Long)groupJson.get(RELEASE_TESTER_COUNT)).intValue();
        return new PersonGroup(id, name, access, testerCount, releaseTesterCount);
    }
}

