/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.onboard;

import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.android.onboard.Code;
import com.crashlytics.tools.android.onboard.CodeChange;
import com.crashlytics.tools.android.onboard.EmptyOnboarder;
import com.crashlytics.tools.android.onboard.Module;
import com.crashlytics.tools.android.onboard.OnboardException;
import com.crashlytics.tools.android.onboard.OnboardingConstants;
import com.crashlytics.tools.android.onboard.Repository;
import com.crashlytics.tools.android.onboard.StubCode;
import com.crashlytics.tools.utils.FileUtils;
import com.crashlytics.tools.utils.GradleParser;
import com.crashlytics.tools.utils.GradleTokenizer;
import com.crashlytics.tools.utils.GradleUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class AndroidGradleOnboarder
extends EmptyOnboarder {
    private final Repository _pluginRepository;
    private final Repository _moduleRepository;
    private final List<Module> _modules;
    private final GradleParser _parser;
    private final Code _gradleCode;

    public static AndroidGradleOnboarder createDefaultAndroidGradleOnboarder(GradleParser parser, Code code) {
        return new AndroidGradleOnboarder(OnboardingConstants.CRASHLYTICS_REPOSITORY, OnboardingConstants.CRASHLYTICS_REPOSITORY, Collections.singletonList(OnboardingConstants.CRASHLYTICS_MODULE), parser, code);
    }

    public AndroidGradleOnboarder(Repository pluginRepository, Repository moduleRepository, List<Module> modules, GradleParser parser, Code gradleCode) {
        this._pluginRepository = pluginRepository;
        this._moduleRepository = moduleRepository;
        this._modules = modules;
        this._gradleCode = gradleCode;
        this._parser = parser;
    }

    @Override
    public List<CodeChange> getCodeChanges() throws OnboardException {
        CodeChange codeChanges = null;
        try {
            GradleParser.SearchResult repositoryResult;
            GradleParser.SearchResult applyCrashlyticsResult = this._parser.findTokenSet(GradleParser.CRASHLYTICS_PLUGIN_STRINGS);
            String codeAsString = this._gradleCode.getCode();
            String lineSeparator = this.getLineSeparator(codeAsString);
            if (applyCrashlyticsResult.wasFound() && codeAsString != null) {
                return Collections.singletonList(new CodeChange("build.gradle", this._gradleCode, Collections.<CodeChange.BlockChange>emptyList()));
            }
            boolean crashlyticsEnabled = false;
            for (Module module : this._modules) {
                crashlyticsEnabled |= module != null && OnboardingConstants.isCrashlyticsModule(module);
            }
            LinkedList<CodeChange.BlockChange> changesToCodeBlocks = new LinkedList<CodeChange.BlockChange>();
            if (crashlyticsEnabled) {
                GradleParser.SearchResult buildscriptResult = this._parser.findNestedClosures("buildscript");
                if (!buildscriptResult.wasFound()) {
                    this.addInsertion(changesToCodeBlocks, 0, GradleUtils.getTabs(0), "buildscript {", lineSeparator, GradleUtils.getTabs(1), "repositories {", lineSeparator, GradleUtils.indentString(this._pluginRepository.getGradleRepositoryString(lineSeparator), 2, lineSeparator), lineSeparator, GradleUtils.getTabs(1), "}", lineSeparator, lineSeparator, GradleUtils.getTabs(1), "dependencies {", lineSeparator, GradleUtils.getTabs(2), "classpath 'com.crashlytics.tools.gradle:crashlytics-gradle:1.+'", lineSeparator, GradleUtils.getTabs(1), "}", lineSeparator, GradleUtils.getTabs(0), "}", lineSeparator);
                } else {
                    GradleParser.SearchResult buildscriptRepositorySearchResult = this._parser.findNestedClosuresEnding("buildscript", "repositories");
                    if (!buildscriptRepositorySearchResult.wasFound()) {
                        this.addInsertion(changesToCodeBlocks, buildscriptResult.getPosition(), lineSeparator, GradleUtils.getTabs(1), "repositories {", lineSeparator, GradleUtils.indentString(this._pluginRepository.getGradleRepositoryString(lineSeparator), 2, lineSeparator), lineSeparator, GradleUtils.getTabs(1), "}", lineSeparator);
                    } else {
                        this.addInsertion(changesToCodeBlocks, buildscriptRepositorySearchResult.getPosition(), lineSeparator, GradleUtils.indentString(this._pluginRepository.getGradleRepositoryString(lineSeparator), 2, lineSeparator));
                    }
                    GradleParser.SearchResult buildscriptDependencyResult = this._parser.findNestedClosuresEnding("buildscript", "dependencies");
                    if (!buildscriptDependencyResult.wasFound()) {
                        this.addInsertion(changesToCodeBlocks, buildscriptResult.getPosition(), lineSeparator, GradleUtils.getTabs(1), "dependencies {", lineSeparator, GradleUtils.getTabs(2), "classpath 'com.crashlytics.tools.gradle:crashlytics-gradle:1.+'", lineSeparator, GradleUtils.getTabs(1), "}", lineSeparator);
                    } else {
                        this.addInsertion(changesToCodeBlocks, buildscriptDependencyResult.getPosition(), lineSeparator, GradleUtils.getTabs(2), "classpath 'com.crashlytics.tools.gradle:crashlytics-gradle:1.+'");
                    }
                }
            }
            GradleParser.SearchResult applyAndroidResult = this._parser.findTokenSet(GradleParser.ANDROID_PLUGIN_STRINGS);
            if (crashlyticsEnabled) {
                if (!applyAndroidResult.wasFound()) {
                    throw new LineNotFoundException("Failed to find apply plugin: 'android' line.");
                }
                this.addInsertion(changesToCodeBlocks, applyAndroidResult.getPosition(), lineSeparator, "apply plugin: 'crashlytics'");
            }
            if (!(repositoryResult = this._parser.findNestedClosuresEnding("repositories")).wasFound()) {
                this.addInsertion(changesToCodeBlocks, applyAndroidResult.getPosition(), lineSeparator, lineSeparator, GradleUtils.getTabs(0), "repositories {", lineSeparator, GradleUtils.indentString(this._moduleRepository.getGradleRepositoryString(lineSeparator), 1, lineSeparator), lineSeparator, GradleUtils.getTabs(0), "}", lineSeparator);
            } else {
                this.addInsertion(changesToCodeBlocks, repositoryResult.getPosition(), lineSeparator, GradleUtils.indentString(this._moduleRepository.getGradleRepositoryString(lineSeparator), 1, lineSeparator));
            }
            GradleParser.SearchResult dependencyPosition = this._parser.findNestedClosuresEnding("dependencies");
            StringBuilder dependencyListBuilder = new StringBuilder();
            for (int m = 0; m < this._modules.size(); ++m) {
                if (m != 0) {
                    dependencyListBuilder.append(lineSeparator);
                }
                dependencyListBuilder.append(this._modules.get(m).getGradleDependencyString(lineSeparator));
            }
            String moduleDependencies = dependencyListBuilder.toString();
            if (!dependencyPosition.wasFound()) {
                this.addInsertion(changesToCodeBlocks, applyAndroidResult.getPosition(), lineSeparator, GradleUtils.getTabs(0), "dependencies {", lineSeparator, GradleUtils.indentString(moduleDependencies, 1, lineSeparator), lineSeparator, GradleUtils.getTabs(0), "}", lineSeparator);
            } else {
                this.addInsertion(changesToCodeBlocks, dependencyPosition.getPosition(), lineSeparator, GradleUtils.indentString(moduleDependencies, 1, lineSeparator));
            }
            codeChanges = new CodeChange("build.gradle", this._gradleCode, changesToCodeBlocks);
        }
        catch (IOException e) {
            DeveloperTools.logW("Crashlytics was unable to parse build.gradle", e);
        }
        catch (LineNotFoundException e) {
            DeveloperTools.logW("Crashlytics was unable to find a necessary line in the file.", e);
        }
        catch (Exception e) {
            DeveloperTools.logW("Crashlytics was unable to parse file.", e);
        }
        return Collections.singletonList(codeChanges);
    }

    @Override
    public List<CodeChange> getCodeChangeDirections() throws OnboardException {
        String panelName = "build.gradle";
        try {
            InputStream manifestStream = AndroidGradleOnboarder.class.getClassLoader().getResourceAsStream("examples/build.gradle.txt");
            String gradleContents = FileUtils.streamToString(manifestStream);
            manifestStream.close();
            StubCode exampleCode = new StubCode(gradleContents);
            AndroidGradleOnboarder onboarder = AndroidGradleOnboarder.createDefaultAndroidGradleOnboarder(new GradleParser(new GradleTokenizer(gradleContents)), exampleCode);
            return onboarder.getCodeChanges();
        }
        catch (OnboardException e) {
            DeveloperTools.logE("Could not onboard build.gradle example at examples/build.gradle.txt", e);
            return Collections.singletonList(CodeChange.createEmptyChange(panelName));
        }
        catch (IOException e) {
            DeveloperTools.logE("Could not load example source: examples/build.gradle.txt", e);
            return Collections.singletonList(CodeChange.createEmptyChange(panelName));
        }
    }

    private void addInsertion(List<CodeChange.BlockChange> changesToCodeBlocks, int insertPosition, String ... text) {
        StringBuilder sb = new StringBuilder();
        for (String item : text) {
            sb.append(item);
        }
        CodeChange.Insertion insertion = new CodeChange.Insertion(insertPosition, sb.toString());
        DeveloperTools.logD(insertion.toString());
        changesToCodeBlocks.add(insertion);
    }

    protected String getLineSeparator(String contents) {
        return FileUtils.getLineSeparator(contents);
    }

    private class LineNotFoundException
    extends Exception {
        public LineNotFoundException(String lineDescription) {
            super(lineDescription);
        }
    }
}

