/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.onboard;

import com.crashlytics.tools.android.onboard.AndroidGradleOnboarder;
import com.crashlytics.tools.android.onboard.AndroidGradlePropertiesOnboarder;
import com.crashlytics.tools.android.onboard.ChainedOnboarder;
import com.crashlytics.tools.android.onboard.Code;
import com.crashlytics.tools.android.onboard.EmptyOnboarder;
import com.crashlytics.tools.android.onboard.ManifestOnboarder;
import com.crashlytics.tools.android.onboard.Module;
import com.crashlytics.tools.android.onboard.Onboarder;
import com.crashlytics.tools.android.onboard.OnboardingConstants;
import com.crashlytics.tools.android.onboard.Repository;
import com.crashlytics.tools.android.project.ManifestProvider;
import com.crashlytics.tools.utils.GradleParser;
import com.crashlytics.tools.utils.GradleTokenizer;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class CommandLineOnboarderFactory {
    private final Repository _repository;
    private final Code _gradleCode;
    private final ManifestProvider _manifestProvider;
    private final String _selectedApiKey;
    private final Code _propertiesIfAuthenticated;
    private final String _currentApiKeyIfAny;

    public CommandLineOnboarderFactory(Repository repository, Code gradleCode, Code propertiesIfAuthenticated, ManifestProvider manifestProvider, String selectedApiKey, String currentApiKeyIfAny) {
        this._repository = repository;
        this._gradleCode = gradleCode;
        this._propertiesIfAuthenticated = propertiesIfAuthenticated;
        this._manifestProvider = manifestProvider;
        this._selectedApiKey = selectedApiKey;
        this._currentApiKeyIfAny = currentApiKeyIfAny;
    }

    public Onboarder createOnboarder(List<Module> modules) throws IOException {
        LinkedList<EmptyOnboarder> onboarders = new LinkedList<EmptyOnboarder>();
        AndroidGradleOnboarder gradleOnboarder = new AndroidGradleOnboarder(OnboardingConstants.BUILDSCRIPT_REPOSITORY, this._repository, modules, new GradleParser(new GradleTokenizer(this._gradleCode.getCode())), this._gradleCode);
        onboarders.add(gradleOnboarder);
        if (this._propertiesIfAuthenticated != null) {
            onboarders.add(new AndroidGradlePropertiesOnboarder(this._repository, this._propertiesIfAuthenticated));
        }
        ManifestOnboarder.OnboardType type = this._selectedApiKey.equals(this._currentApiKeyIfAny) ? ManifestOnboarder.OnboardType.INJECT_INTERNET_PERMISSION : ManifestOnboarder.OnboardType.INJECT_BOTH;
        onboarders.add(new ManifestOnboarder(this._manifestProvider, this._selectedApiKey, type));
        return new ChainedOnboarder(onboarders.toArray(new Onboarder[onboarders.size()]));
    }
}

