/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.onboard;

import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.android.onboard.Code;
import com.crashlytics.tools.android.onboard.CodeChange;
import com.crashlytics.tools.android.onboard.EmptyOnboarder;
import com.crashlytics.tools.android.onboard.OnboardException;
import com.crashlytics.tools.android.onboard.StubCode;
import com.crashlytics.tools.android.project.ManifestData;
import com.crashlytics.tools.android.project.ManifestProvider;
import com.crashlytics.tools.utils.FileUtils;
import com.crashlytics.tools.utils.xml.ElementOffsetFinder;
import com.crashlytics.tools.utils.xml.XmlUtils;
import com.google.common.base.Optional;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.io.IOUtils;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class ManifestOnboarder
extends EmptyOnboarder {
    private final String _apiKeyToInject;
    protected final ManifestProvider _manifestProvider;
    private final OnboardType _onboardingType;

    public ManifestOnboarder(ManifestProvider manifestProvider, String apiKeyToOnboard, OnboardType onboardingType) {
        this._manifestProvider = manifestProvider;
        this._apiKeyToInject = apiKeyToOnboard;
        this._onboardingType = onboardingType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CodeChange> getCodeChanges() throws OnboardException {
        LinkedList<CodeChange.BlockChange> changes = new LinkedList<CodeChange.BlockChange>();
        InputStream manifestSearchedForAppOffset = null;
        try {
            boolean apiNeedsUpdating;
            ManifestData manifestData = this._manifestProvider.getManifestData();
            File manifestFile = this._manifestProvider.getManifestFile();
            Code manifestCode = this._manifestProvider.getManifestCode();
            boolean usesInternet = !this._onboardingType.equals((Object)OnboardType.INJECT_API_KEY) && manifestData.usesPermission("android.permission.INTERNET");
            Optional<String> manifestApiKey = manifestData.getApiKey();
            boolean bl = apiNeedsUpdating = !this._onboardingType.equals((Object)OnboardType.INJECT_INTERNET_PERMISSION);
            if (usesInternet && !apiNeedsUpdating) {
                List<CodeChange> list = Collections.singletonList(new CodeChange(manifestFile.getName(), manifestCode, changes));
                return list;
            }
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLStreamReader xmlReader = factory.createXMLStreamReader(this._manifestProvider.getManifestStream());
            String fileContents = this._manifestProvider.getManifestString();
            manifestSearchedForAppOffset = this._manifestProvider.getManifestStream();
            String lineSep = this.getLineSeparator(fileContents);
            this.logLineSep(lineSep);
            String applicationIndent = XmlUtils.getIndent(xmlReader, lineSep, "application");
            ElementOffsetFinder appOffset = ElementOffsetFinder.getElementOffset(manifestSearchedForAppOffset, "application");
            changes = new LinkedList();
            if (!usesInternet) {
                Locator permissionsLocator = appOffset.getStartOffsetLocator();
                InputStream manifestSearchedForPermissions = null;
                try {
                    manifestSearchedForPermissions = this._manifestProvider.getManifestStream();
                    int permissionsOffset = FileUtils.locatorCharacterOffset(manifestSearchedForPermissions, permissionsLocator);
                    changes.add(new CodeChange.Insertion(permissionsOffset, lineSep + lineSep + applicationIndent + "<uses-permission android:name=\"android.permission.INTERNET\"/>"));
                }
                finally {
                    IOUtils.closeQuietly(manifestSearchedForPermissions);
                }
            }
            if (apiNeedsUpdating) {
                if (manifestApiKey.isPresent()) {
                    HashMap<String, String> attributes = new HashMap<String, String>();
                    attributes.put("android:name", "com.crashlytics.ApiKey");
                    InputStream manifestSearchedForApiKey = null;
                    try {
                        manifestSearchedForApiKey = this._manifestProvider.getManifestStream();
                        ElementOffsetFinder apiKeyOffset = ElementOffsetFinder.getElementOffset(manifestSearchedForApiKey, "meta-data", attributes);
                        Locator locator = apiKeyOffset.getStartOffsetLocator();
                        int pos = FileUtils.locatorCharacterOffset(manifestSearchedForAppOffset, locator);
                        if (pos == -1) {
                            throw new RuntimeException("Unexpected: API Key was present in XML, failed");
                        }
                        int startDelete = fileContents.indexOf(manifestApiKey.get(), pos);
                        int endDelete = manifestApiKey.get().length() + startDelete;
                        changes.add(new CodeChange.Deletion(startDelete, endDelete));
                        changes.add(new CodeChange.Insertion(endDelete, this._apiKeyToInject));
                    }
                    finally {
                        IOUtils.closeQuietly(manifestSearchedForApiKey);
                    }
                }
                InputStream manifestSearchedForMetadata = null;
                try {
                    manifestSearchedForMetadata = this._manifestProvider.getManifestStream();
                    String metadataElementStr = lineSep + this.createMetadataElement(applicationIndent);
                    Locator metadataLocator = appOffset.getEndOffsetLocator();
                    int metadataOffset = FileUtils.locatorCharacterOffset(manifestSearchedForMetadata, metadataLocator);
                    changes.add(new CodeChange.Insertion(metadataOffset, metadataElementStr));
                }
                finally {
                    IOUtils.closeQuietly(manifestSearchedForMetadata);
                }
            }
            DeveloperTools.logD("Proposed Changes:\n" + changes);
            List<CodeChange> list = Collections.singletonList(new CodeChange(manifestFile.getName(), manifestCode, changes));
            IOUtils.closeQuietly(manifestSearchedForAppOffset);
            return list;
        }
        catch (ManifestData.ManifestIOException e) {
            throw new OnboardException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new OnboardException("Crashlytics could not read the manifest. ", e);
        }
        catch (SAXException e) {
            throw new OnboardException("Crashlytics could not parse the manifest.", e);
        }
        catch (ParserConfigurationException e) {
            throw new OnboardException("Crashlytics could not configure the parser.", e);
        }
        catch (XMLStreamException e) {
            throw new OnboardException("Crashlytics could not parse the manifest xml.", e);
        }
        catch (Exception e) {
            throw new OnboardException("Crashlytics could not get changes for manifest.", e);
        }
        finally {
            IOUtils.closeQuietly(manifestSearchedForAppOffset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCodeChangeDirectionContents() {
        String manifestContents = null;
        InputStream manifestStream = null;
        try {
            manifestStream = ManifestOnboarder.class.getClassLoader().getResourceAsStream("examples/AndroidManifest.xml.txt");
            manifestContents = FileUtils.streamToString(manifestStream);
        }
        catch (Exception e) {
            DeveloperTools.logE("Could not load example manifest: examples/AndroidManifest.xml.txt", e);
        }
        finally {
            try {
                manifestStream.close();
            }
            catch (IOException e) {
                DeveloperTools.logW("Crashlytics could not close example manifest: examples/AndroidManifest.xml.txt", e);
            }
        }
        return manifestContents;
    }

    @Override
    public List<CodeChange> getCodeChangeDirections() {
        String manifestContents = this.getCodeChangeDirectionContents();
        if (manifestContents == null) {
            return Collections.singletonList(CodeChange.createEmptyChange("AndroidManifest.xml"));
        }
        LinkedList<CodeChange.BlockChange> changes = new LinkedList<CodeChange.BlockChange>();
        String permissionSearchContent = "android:targetSdkVersion=\"15\" />";
        int permissionOffset = manifestContents.indexOf(permissionSearchContent) + permissionSearchContent.length() + 1;
        changes.add(new CodeChange.Insertion(permissionOffset, "  <uses-permission android:name=\"android.permission.INTERNET\"/>\n"));
        String apiSearchContent = "</activity>";
        int apiOffset = manifestContents.indexOf(apiSearchContent) + apiSearchContent.length() + 1;
        changes.add(new CodeChange.Insertion(apiOffset, "  " + String.format("<meta-data android:name=\"com.crashlytics.ApiKey\" android:value=\"%s\"/>", this._apiKeyToInject) + "\n\n"));
        return Collections.singletonList(new CodeChange("AndroidManifest.xml", new StubCode(manifestContents), changes));
    }

    private String createMetadataElement(String indent) {
        return indent + indent + String.format("<meta-data android:name=\"com.crashlytics.ApiKey\" android:value=\"%s\"/>", this._apiKeyToInject);
    }

    protected String getLineSeparator(String contents) {
        return FileUtils.getLineSeparator(contents);
    }

    private void logLineSep(String lineSep) {
        if (lineSep.equals("\r")) {
            DeveloperTools.logD("Crashlytics identified line separator: r (Mac 9 and below)");
        } else if (lineSep.equals("\r\n")) {
            DeveloperTools.logD("Crashlytics identified line separator: rn (Windows)");
        } else if (lineSep.equals("\n\r")) {
            DeveloperTools.logD("Crashlytics identified line separator: nr (Unexpected)");
        } else if (lineSep.equals("\n")) {
            DeveloperTools.logD("Crashlytics identified line separator: n (Unix)");
        } else {
            DeveloperTools.logD("Crashlytics identified line separator: [" + lineSep + "] (Unknown)");
        }
    }

    public static enum OnboardType {
        INJECT_API_KEY,
        INJECT_INTERNET_PERMISSION,
        INJECT_BOTH;

    }
}

