/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.onboard;

import com.crashlytics.tools.utils.GradleUtils;

public class Repository {
    private final String _url;
    private final String _username;
    private final String _password;
    private String _gradleRepository = null;

    public static Repository createPublicRepository(String url) {
        return new Repository(url, null, null);
    }

    public static Repository createAuthenticatedRepository(String url, String username, String password) {
        if (username == null || password == null) {
            throw new IllegalArgumentException();
        }
        return new Repository(url, username, password);
    }

    public boolean isAuthenticated() {
        return this._username != null && this._password != null;
    }

    private Repository(String url, String username, String password) {
        this._url = url;
        this._username = username;
        this._password = password;
    }

    public String getUrl() {
        return this._url;
    }

    public String getUsername() {
        return this._username;
    }

    public String getPassword() {
        return this._password;
    }

    public String getGradleRepositoryString(String lineSeparator) {
        if (this._gradleRepository == null) {
            this._gradleRepository = this.buildGradleRepositoryString(lineSeparator);
        }
        return this._gradleRepository;
    }

    private String buildGradleRepositoryString(String lineSeparator) {
        if (this.isAuthenticated()) {
            return "maven {" + lineSeparator + GradleUtils.getTabs(1) + "url '" + this._url + "'" + lineSeparator + GradleUtils.getTabs(1) + "credentials {" + lineSeparator + GradleUtils.getTabs(2) + "username = '" + this._username + "'" + lineSeparator + GradleUtils.getTabs(2) + "password = '" + this._password + "'" + lineSeparator + GradleUtils.getTabs(1) + "}" + lineSeparator + "}";
        }
        return "maven { url '" + this._url + "' }";
    }
}

