/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.onboard;

import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.android.SDKManager;
import com.crashlytics.tools.android.onboard.OnboardException;
import com.crashlytics.tools.android.onboard.WorkspaceChange;
import java.util.concurrent.CountDownLatch;

public class SdkWorkspaceChange
implements WorkspaceChange {
    protected final SDKManager _manager;
    protected final String _apiKeyToOnboard;
    private final CountDownLatch _sdkAvailableLatch = new CountDownLatch(1);
    private final Runnable _ensureSdkAvailableRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                SDKManager sdkManager = SdkWorkspaceChange.this.getSdkManager();
                String apiKey = SdkWorkspaceChange.this._apiKeyToOnboard;
                if (sdkManager.isSdkAvailable(apiKey)) {
                    DeveloperTools.logD("An SDK is available for API key " + apiKey + ". Proceeding with onboarding.");
                    SdkWorkspaceChange.this._sdkAvailableLatch.countDown();
                } else {
                    DeveloperTools.logD("An SDK is not available for API key " + apiKey + ". Requesting a download and retrying.");
                    sdkManager.updateCachedSDK(DeveloperTools.getWebApi(), apiKey);
                    Thread.sleep(1000L);
                    SdkWorkspaceChange.this.ensureSdkAvailable();
                }
            }
            catch (Exception e) {
                DeveloperTools.logE("Encountered an error while ensuring an SDK is present.", e);
            }
        }
    };

    public SdkWorkspaceChange(String apiKeyToOnboard, SDKManager manager) {
        this._apiKeyToOnboard = apiKeyToOnboard;
        this._manager = manager;
    }

    public SDKManager getSdkManager() {
        return this._manager;
    }

    private void ensureSdkAvailable() {
        new Thread(this._ensureSdkAvailableRunnable, "Crashlytics Ensure SDK Present").start();
    }

    @Override
    public void applyChange() throws OnboardException {
        this.ensureSdkAvailable();
        try {
            this._sdkAvailableLatch.await();
        }
        catch (InterruptedException e) {
            DeveloperTools.logE("Crashlytics was interrupted while waiting for an SDK to be available.", e);
        }
    }
}

