/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.proguard;

import com.crashlytics.tools.android.ObfuscatorConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class ProguardConfig
implements ObfuscatorConfig {
    public static final String PROGUARD_ID = "proguard";
    private static final String PROGUARD_CONFIG_PROPERTY = "proguard.config";
    private static final String DEFAULT_MAPPING_FILE = "mapping.txt";
    public static final String OPTION_DONT_OBFUSCATE = "-dontobfuscate";
    public static final String OPTION_PRINT_MAPPING = "-printmapping";
    private List<File> _configFiles = null;
    private boolean _obfuscates = false;
    private File _deobfuscationFile = null;
    private final String _version;

    public static String getProguardVersion(File proguardHome) {
        return "4.7";
    }

    public ProguardConfig(List<File> proguardConfigFiles, String version) throws IOException {
        this._version = version;
        this.updateConfig(proguardConfigFiles);
    }

    public List<File> getConfigFiles() {
        return this._configFiles;
    }

    @Override
    public void updateConfig(List<File> configFiles) throws IOException {
        this._obfuscates = !configFiles.isEmpty();
        this._deobfuscationFile = null;
        this._configFiles = new LinkedList<File>(configFiles);
        if (configFiles.isEmpty()) {
            return;
        }
        boolean dontObfuscate = false;
        String mappingFile = this.getDefaultMappingsFile();
        for (File configFile : configFiles) {
            BufferedReader reader = null;
            try {
                String line;
                reader = new BufferedReader(new FileReader(configFile));
                while ((line = reader.readLine()) != null) {
                    if (line.contains("#")) {
                        line = line.substring(0, line.indexOf("#"));
                    }
                    if ((line = line.trim()).startsWith(OPTION_DONT_OBFUSCATE)) {
                        dontObfuscate = true;
                        continue;
                    }
                    if (!line.startsWith(OPTION_PRINT_MAPPING)) continue;
                    mappingFile = line.replaceFirst(OPTION_PRINT_MAPPING, "").trim();
                }
            }
            catch (IOException e) {
                throw e;
            }
            finally {
                if (reader == null) continue;
                reader.close();
            }
        }
        boolean bl = this._obfuscates = !dontObfuscate;
        if (this._obfuscates) {
            this._deobfuscationFile = new File(mappingFile);
        }
    }

    protected String getDefaultMappingsFile() {
        return DEFAULT_MAPPING_FILE;
    }

    @Override
    public boolean isObsfucationEnabled() {
        return this._obfuscates;
    }

    @Override
    public File getDeobfuscationFile() {
        return this._deobfuscationFile;
    }

    @Override
    public String getObfuscatorId() {
        return PROGUARD_ID;
    }

    @Override
    public String getObfuscatorVersion() {
        return this._version;
    }

    public static File findProguardConfigFile(File projectProperties) throws FileNotFoundException, IOException {
        if (!projectProperties.exists()) {
            throw new FileNotFoundException("Properties file not found: " + projectProperties);
        }
        Properties props = new Properties();
        props.load(new FileReader(projectProperties));
        if (props.contains(PROGUARD_CONFIG_PROPERTY)) {
            String filename = (String)props.get(PROGUARD_CONFIG_PROPERTY);
            return new File(filename);
        }
        return null;
    }
}

