/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.project;

import com.android.sdklib.xml.AndroidManifestParser;
import com.android.sdklib.xml.ManifestData;
import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.android.project.ManifestData;
import com.crashlytics.tools.android.project.ManifestFileProvider;
import com.crashlytics.tools.android.project.ManifestProvider;
import com.google.common.base.Optional;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultManifestData
implements ManifestData {
    private static final String PNG_EXTENSION = ".png";
    private static final String ANDROID_NAME_ATTRIBUTE = "android:name";
    private static final String ANDROID_VALUE_ATTRIBUTE = "android:value";
    private static final String ANDROID_LABEL_ATTRIBUTE = "android:label";
    private static final String ANDROID_VERSION_NAME_ATTRIBUTE = "android:versionName";
    private static final String ANDROID_ICON_ATTRIBUTE = "android:icon";
    private static final String META_DATA_NODE = "meta-data";
    private static final String DRAWABLE_REFERENCE_PREFIX = "@drawable/";
    private static final String STRING_REFERENCE_PREFIX = "@string/";
    private static final String STRING_NODE = "string";
    private static final String NAME_ATTRIBUTE = "name";
    private static final FileFilter XML_FILES_FILTER = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return f.isFile() && f.getName().toLowerCase().endsWith(".xml");
        }
    };
    private static final List<String> SEARCHED_RES_FOLDERS = new ArrayList<String>(){
        {
            this.add("values-" + Locale.getDefault().getLanguage());
            this.add("values");
        }
    };
    private final File _resDir;
    private final String _versionName;
    private final Set<String> _services;
    private final Set<String> _usesPermissions;
    private final Hashtable<String, String> _metaData;
    private final String _packageName;
    private final Integer _versionCodeOrNull;
    private final String _launcherActivityName;
    private final String _applicationName;
    private String _iconName = null;
    private String _applicationClass = null;
    private Optional<String> _apiKey;
    private static final FilenameFilter DRAWABLE_FOLDER_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.startsWith("drawable") && new File(dir, name).isDirectory();
        }
    };
    private static final FilenameFilter PNG_FILE_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.toLowerCase().endsWith(DefaultManifestData.PNG_EXTENSION);
        }
    };

    public static DefaultManifestData createManifest(File manifestFile) throws ManifestData.ManifestIOException {
        return DefaultManifestData.createManifest(new ManifestFileProvider(manifestFile));
    }

    public static DefaultManifestData createManifest(ManifestProvider manifestProvider) throws ManifestData.ManifestIOException {
        File manifestFile = manifestProvider.getManifestFile();
        File resDir = new File(manifestFile.getParentFile(), "res");
        return DefaultManifestData.createManifest(manifestProvider, resDir);
    }

    public static DefaultManifestData createManifest(ManifestProvider manifestProvider, File resDir) throws ManifestData.ManifestIOException {
        String versionName;
        com.android.sdklib.xml.ManifestData data;
        String manifestPathOnDisk = manifestProvider.getManifestFile().getAbsolutePath();
        HashSet<String> services = new HashSet<String>();
        HashSet<String> usesPermissions = new HashSet<String>();
        Hashtable<String, String> metaData = new Hashtable<String, String>();
        String iconName = null;
        String applicationClass = null;
        String applicationName = null;
        InputStream inputStream = manifestProvider.getManifestStream();
        try {
            data = AndroidManifestParser.parse(inputStream);
        }
        catch (Exception e) {
            throw new ManifestData.ManifestIOException("Crashlytics could not parse " + manifestPathOnDisk + " as an Android manifest.", e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                throw new ManifestData.ManifestIOException("Crashlytics could not close the manifest input stream.");
            }
        }
        String packageName = data.getPackage();
        if (packageName == null) {
            DeveloperTools.logD("Crashlytics could not find a package name. This will likely cause issues during upload deobs files.");
        }
        inputStream = manifestProvider.getManifestStream();
        try {
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = docBuilder.parse(inputStream);
            Element manifestRoot = doc.getDocumentElement();
            versionName = manifestRoot.getAttribute(ANDROID_VERSION_NAME_ATTRIBUTE);
            services.clear();
            NodeList appNodes = manifestRoot.getElementsByTagName("application");
            if (appNodes.getLength() != 0) {
                Element applicationEl = (Element)appNodes.item(0);
                if (applicationEl.hasAttribute(ANDROID_ICON_ATTRIBUTE)) {
                    iconName = applicationEl.getAttribute(ANDROID_ICON_ATTRIBUTE).replaceFirst(DRAWABLE_REFERENCE_PREFIX, "");
                }
                if (applicationEl.hasAttribute(ANDROID_NAME_ATTRIBUTE)) {
                    String nameAttrValue = applicationEl.getAttribute(ANDROID_NAME_ATTRIBUTE);
                    applicationClass = nameAttrValue.startsWith(".") ? packageName + nameAttrValue : nameAttrValue;
                }
                if (applicationEl.hasAttribute(ANDROID_LABEL_ATTRIBUTE)) {
                    String labelAttrValue = applicationEl.getAttribute(ANDROID_LABEL_ATTRIBUTE);
                    if (labelAttrValue.startsWith(STRING_REFERENCE_PREFIX)) {
                        String referenceName = labelAttrValue.replaceFirst(STRING_REFERENCE_PREFIX, "");
                        applicationName = DefaultManifestData.findStringResourceInResRoot(referenceName, resDir, packageName);
                    } else {
                        applicationName = labelAttrValue;
                    }
                } else {
                    applicationName = null;
                }
                NodeList serviceNodes = applicationEl.getElementsByTagName("service");
                for (int i = 0; i < serviceNodes.getLength(); ++i) {
                    String serviceName = ((Element)serviceNodes.item(i)).getAttribute(NAME_ATTRIBUTE);
                    if (serviceName == null) continue;
                    services.add(serviceName);
                }
                NodeList metaDataNodes = applicationEl.getElementsByTagName(META_DATA_NODE);
                for (int i = 0; i < metaDataNodes.getLength(); ++i) {
                    Element e = (Element)metaDataNodes.item(i);
                    String name = e.getAttribute(ANDROID_NAME_ATTRIBUTE);
                    String value = e.getAttribute(ANDROID_VALUE_ATTRIBUTE);
                    metaData.put(name, value);
                }
                NodeList usesPermissionNodes = manifestRoot.getElementsByTagName("uses-permission");
                for (int i = 0; i < usesPermissionNodes.getLength(); ++i) {
                    Element e = (Element)usesPermissionNodes.item(i);
                    String permission = e.getAttribute(ANDROID_NAME_ATTRIBUTE);
                    usesPermissions.add(permission);
                }
            }
        }
        catch (Exception e) {
            throw new ManifestData.ManifestIOException("Crashlytics could not parse the manifest found at " + manifestPathOnDisk, e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                throw new ManifestData.ManifestIOException("Crashlytics could not close the manifest input stream.");
            }
        }
        Integer versionCode = data.getVersionCode();
        ManifestData.Activity launcherActivity = data.getLauncherActivity();
        String launcherActivityName = launcherActivity == null ? null : launcherActivity.getName();
        String apiKey = (String)metaData.get("com.crashlytics.ApiKey");
        return new DefaultManifestData(resDir, applicationName, versionName, services, usesPermissions, metaData, iconName, applicationClass, packageName, versionCode, launcherActivityName, Optional.fromNullable(apiKey));
    }

    private static String findStringResourceInResRoot(String stringName, File resDir, String defaultValue) {
        String value = null;
        if (resDir.isDirectory()) {
            for (String folder : SEARCHED_RES_FOLDERS) {
                if (value != null) break;
                final String folderName = folder;
                String[] matchingDirs = resDir.list(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return dir.isDirectory() && folderName.equalsIgnoreCase(name);
                    }
                });
                if (matchingDirs == null || matchingDirs.length <= 0) continue;
                value = DefaultManifestData.findStringResourceInResDir(stringName, new File(resDir, matchingDirs[0]));
            }
        }
        return value == null ? defaultValue : value;
    }

    private static String findStringResourceInResDir(String stringName, File resDir) {
        File[] xmlFiles;
        String value = null;
        if (resDir.isDirectory() && (xmlFiles = resDir.listFiles(XML_FILES_FILTER)) != null) {
            for (File f : xmlFiles) {
                if (value != null) break;
                value = DefaultManifestData.findStringResourceInFile(stringName, f);
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String findStringResourceInFile(String stringName, File resFile) {
        String string;
        BufferedInputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(resFile));
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = docBuilder.parse(inputStream);
            Element resourcesRoot = doc.getDocumentElement();
            NodeList stringNodes = resourcesRoot.getElementsByTagName(STRING_NODE);
            for (int i = 0; i < stringNodes.getLength(); ++i) {
                Node stringNode = stringNodes.item(i);
                String nodeName = ((Element)stringNode).getAttribute(NAME_ATTRIBUTE);
                if (!stringName.equals(nodeName)) continue;
                string = stringNode.getTextContent();
            }
        }
        catch (Exception e) {
            try {
                DeveloperTools.logW("Crashlytics could not parse the resources file found at " + resFile.getAbsolutePath(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
            IOUtils.closeQuietly(inputStream);
            return null;
        }
        IOUtils.closeQuietly(inputStream);
        return null;
        IOUtils.closeQuietly(inputStream);
        return string;
    }

    public DefaultManifestData(File resDir, String applicationName, String versionName, Set<String> services, Set<String> usesPermissions, Hashtable<String, String> metaData, String iconName, String applicationClass, String packageName, Integer versionCodeOrNull, String launcherActivityName, Optional<String> apiKey) {
        this._resDir = resDir;
        this._applicationName = applicationName;
        this._versionName = versionName;
        this._services = services;
        this._usesPermissions = usesPermissions;
        this._metaData = metaData;
        this._iconName = iconName;
        this._applicationClass = applicationClass;
        this._packageName = packageName;
        this._versionCodeOrNull = versionCodeOrNull;
        this._launcherActivityName = launcherActivityName;
        this._apiKey = apiKey;
    }

    protected DefaultManifestData() {
        this(null, null, null, null, null, null, null, null, null, null, null, null);
    }

    @Override
    public File getLauncherIcon() {
        if (this._iconName == null || !this._resDir.exists()) {
            return null;
        }
        int iconNameLength = this._iconName.length() + PNG_EXTENSION.length();
        for (File drawableDir : this._resDir.listFiles(DRAWABLE_FOLDER_FILTER)) {
            for (String drawable : drawableDir.list(PNG_FILE_FILTER)) {
                if (drawable.length() != iconNameLength || !drawable.startsWith(this._iconName)) continue;
                return new File(drawableDir.getAbsoluteFile(), drawable);
            }
        }
        return null;
    }

    @Override
    public String getApplicationName() {
        return this._applicationName;
    }

    @Override
    public Integer getVersionCodeOrNull() {
        return this._versionCodeOrNull;
    }

    @Override
    public String getVersionName() {
        return this._versionName;
    }

    @Override
    public boolean declaresService(String serviceName) {
        return this._services.contains(serviceName);
    }

    @Override
    public String getMainActivity() {
        return this._launcherActivityName;
    }

    @Override
    public String getApplicationClass() {
        return this._applicationClass;
    }

    @Override
    public Hashtable<String, String> getMetaData() {
        return this._metaData;
    }

    @Override
    public boolean usesPermission(String permission) {
        return this._usesPermissions.contains(permission);
    }

    @Override
    public String getPackageName() {
        return this._packageName;
    }

    @Override
    public Optional<String> getApiKey() {
        return this._apiKey;
    }
}

