/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.utils;

import com.crashlytics.tools.utils.GradleTokenizer;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class GradleParser {
    private GradleTokenizer _tokenizer;
    public static final String[] ANDROID_PLUGIN_STRINGS = new String[]{"apply", "plugin:", "'", "android", "'"};
    public static final String[] CRASHLYTICS_PLUGIN_STRINGS = new String[]{"apply", "plugin:", "'", "crashlytics", "'"};

    public GradleParser(GradleTokenizer tokenizer) {
        this._tokenizer = tokenizer;
    }

    private int passThroughCodeBlock(int delta, boolean returnAfterExitBracket) {
        String token = this._tokenizer.next();
        int length = token.length();
        String trimmedToken = token.trim();
        while (null != token) {
            if (trimmedToken.equals("{")) {
                int result = this.passThroughCodeBlock(delta + length, true);
                if (result == -1) {
                    return -1;
                }
                delta = result;
            } else {
                if (trimmedToken.equals("}")) {
                    if (returnAfterExitBracket) {
                        return delta + length;
                    }
                    return delta;
                }
                delta += length;
            }
            token = this._tokenizer.next();
            length = token.length();
            trimmedToken = token.trim();
        }
        return -1;
    }

    public SearchResult findTokenSet(String ... tokens) {
        this._tokenizer.reset();
        boolean found = false;
        String currentToken = this._tokenizer.next();
        int currentItem = 0;
        int currentOffset = 0;
        while (!found) {
            if (currentItem == tokens.length) {
                found = true;
                break;
            }
            if (currentToken == null) break;
            currentItem = tokens[currentItem].equals(currentToken.trim()) ? ++currentItem : 0;
            currentOffset += currentToken.length();
            currentToken = this._tokenizer.next();
        }
        if (found) {
            return SearchResult.found(currentOffset);
        }
        return SearchResult.eof();
    }

    public SearchResult findNestedClosures(String ... searchItems) throws IOException {
        this._tokenizer.reset();
        SearchResult result = this.findNestedClosuresInScope(Arrays.asList(searchItems));
        return result;
    }

    public SearchResult findNestedClosuresEnding(String ... searchItems) throws IOException {
        this._tokenizer.reset();
        SearchResult result = this.findNestedClosuresInScope(Arrays.asList(searchItems));
        if (result.wasFound()) {
            int endOfBlock = this.passThroughCodeBlock(result.getPosition(), false);
            if (endOfBlock == -1) {
                result = SearchResult.eof();
            }
            result = SearchResult.found(endOfBlock);
        }
        return result;
    }

    private SearchResult findNestedClosuresInScope(List<String> identifiers) throws IOException {
        if (identifiers.size() == 0) {
            return SearchResult.found(this._tokenizer.getPosition());
        }
        String head = identifiers.get(0);
        List<String> tail = identifiers.subList(1, identifiers.size());
        SearchResult currentSearch = this.findClosureInScope(head);
        while (currentSearch.wasFound() && SearchResult.Result.NOT_FOUND_IN_REGION == (currentSearch = this.findNestedClosuresInScope(tail)).getResult()) {
            currentSearch = this.findClosureInScope(head);
        }
        return currentSearch;
    }

    /*
     * Enabled aggressive block sorting
     */
    private SearchResult findClosureInScope(String identifier) throws IOException {
        int currentPosition = 0;
        String lastToken = null;
        String token = this._tokenizer.next();
        while (true) {
            block6: {
                if (token == null) {
                    return SearchResult.eof();
                }
                currentPosition += token.length();
                if (token.trim().equals("{")) {
                    if (token != null && !identifier.equals(lastToken.trim())) {
                        currentPosition = this.passThroughCodeBlock(currentPosition, true);
                        break block6;
                    } else {
                        if (token.trim().equals("}")) {
                            return SearchResult.notFound(currentPosition);
                        }
                        return SearchResult.found(currentPosition);
                    }
                }
                lastToken = token;
            }
            token = this._tokenizer.next();
        }
    }

    private boolean findPropertyInScope(LinkedList<String> identifiers) {
        if (identifiers.isEmpty()) {
            return true;
        }
        boolean result = false;
        String token = this._tokenizer.next();
        while (token != null) {
            String trimmedToken = token.trim();
            if (this.isEndOfClosure(trimmedToken)) {
                result = false;
            } else if (this.isStartOfNewClosure(trimmedToken)) {
                this.passThroughCodeBlock(0, true);
            } else if (this.isMethodInvocationOrPropertyDefinition(trimmedToken)) {
                this.passThroughNamespace(0, token);
            } else if (trimmedToken.equals(identifiers.get(0))) {
                LinkedList<String> identifiersLeft = new LinkedList<String>(identifiers);
                identifiersLeft.pop();
                if (identifiersLeft.size() == 0) {
                    result = true;
                } else {
                    boolean namespaceDeclarationMatchesTargetNamespace = this.extractIdentifiersFromNamespaceDeclaration(identifiersLeft);
                    if (namespaceDeclarationMatchesTargetNamespace) {
                        result = this.findPropertyInScope(identifiersLeft);
                    }
                }
                if (result) break;
            }
            if ((token = this._tokenizer.next()) != null) continue;
            result = false;
            break;
        }
        return result;
    }

    private boolean isMethodInvocationOrPropertyDefinition(String trimmedToken) {
        return ".".equals(trimmedToken);
    }

    private boolean isEndOfClosure(String trimmedToken) {
        return "}".equals(trimmedToken);
    }

    private boolean isStartOfNewClosure(String trimmedToken) {
        return "{".equals(trimmedToken);
    }

    private boolean extractIdentifiersFromNamespaceDeclaration(LinkedList<String> identifiersToExtract) {
        block3: {
            while (true) {
                if (identifiersToExtract.size() == 0) {
                    return true;
                }
                boolean nextTokenIsNamespace = this._tokenizer.peek().trim().equals(".");
                if (!nextTokenIsNamespace) break block3;
                this._tokenizer.next();
                boolean nextTokenMatchesNextIdentifier = this._tokenizer.peek().trim().equals(identifiersToExtract.get(0));
                if (!nextTokenMatchesNextIdentifier) break;
                identifiersToExtract.pop();
                this._tokenizer.next();
            }
            this._tokenizer.next();
            return false;
        }
        if (this._tokenizer.peek().trim().equals("{")) {
            this._tokenizer.next();
            return true;
        }
        return false;
    }

    private int passThroughNamespace(int currentPosition, String lastToken) {
        String token = this._tokenizer.peek();
        while (token != null && (".".equals(lastToken.trim()) || ".".equals(token.trim()))) {
            this._tokenizer.next();
            currentPosition += token.length();
            lastToken = token;
            token = this._tokenizer.peek();
        }
        return currentPosition;
    }

    public boolean isAndroidGradleProject() {
        return this.findTokenSet(ANDROID_PLUGIN_STRINGS).wasFound();
    }

    public SearchResult findProperty(String ... propertyPath) {
        this._tokenizer.reset();
        if (this.findPropertyInScope(new LinkedList<String>(Arrays.asList(propertyPath)))) {
            return SearchResult.found(this._tokenizer.getPosition());
        }
        return SearchResult.notFound(this._tokenizer.getPosition());
    }

    public List<String> getStringListProperty(String ... propertyPath) {
        this._tokenizer.reset();
        SearchResult result = this.findProperty(propertyPath);
        if (result.wasFound()) {
            this.removeAnyAssignments();
            return this.getList();
        }
        return null;
    }

    public String getStringProperty(String ... propertyPath) {
        this._tokenizer.reset();
        SearchResult result = this.findProperty(propertyPath);
        if (result.wasFound()) {
            this.removeAnyAssignments();
            return this._tokenizer.extractString();
        }
        return null;
    }

    private void removeAnyAssignments() {
        String next = this._tokenizer.peek().trim();
        if (next.equals("=")) {
            this._tokenizer.next();
        }
    }

    private List<String> getList() {
        String next = this._tokenizer.next();
        LinkedList<String> item = new LinkedList<String>();
        if (next.trim().equals("[")) {
            while (next != null) {
                String nextString;
                String trimmedNext = next.trim();
                if (trimmedNext.equals("]")) {
                    this._tokenizer.next();
                    break;
                }
                if (trimmedNext.equals(",")) {
                    this._tokenizer.next();
                }
                if ((nextString = this._tokenizer.extractString()) == null) break;
                item.add(nextString);
                next = this._tokenizer.peek();
            }
        }
        return item;
    }

    public static class SearchResult {
        private Result _searchResult;
        private int _position;

        private SearchResult(Result searchResult, int position) {
            this._searchResult = searchResult;
            this._position = position;
        }

        public static SearchResult eof() {
            return new SearchResult(Result.REACHED_EOF, -1);
        }

        public static SearchResult notFound(int lastOffsetOfSearch) {
            if (lastOffsetOfSearch < 0) {
                throw new IllegalArgumentException("Last position of search was out of bounds, search expected non-negative search region");
            }
            return new SearchResult(Result.NOT_FOUND_IN_REGION, lastOffsetOfSearch);
        }

        public static SearchResult found(int lastIndexOfResult) {
            return new SearchResult(Result.FOUND, lastIndexOfResult);
        }

        public boolean wasFound() {
            return Result.FOUND == this._searchResult;
        }

        public Result getResult() {
            return this._searchResult;
        }

        public int getPosition() {
            return this._position;
        }

        public String toString() {
            return "Search Result: " + (Object)((Object)this._searchResult) + " (" + this._position + ")";
        }

        public static enum Result {
            FOUND,
            NOT_FOUND_IN_REGION,
            REACHED_EOF;

        }
    }
}

