/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics;

import com.crashlytics.AbstractCrashlyticsMojo;
import com.crashlytics.DeveloperToolsUtils;
import com.crashlytics.MojoLogger;
import com.crashlytics.tools.android.DeveloperTools;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Parameter;

@org.apache.maven.plugins.annotations.Mojo(name="GenerateResources", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class CrashlyticsGenerateResourcesMojo
extends AbstractCrashlyticsMojo {
    @Parameter
    private String projectPath;
    @Parameter
    private String androidResPath;
    @Parameter
    private String androidManifestPath;

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)"Crashlytics - GenerateResources");
        this.getLog().debug((CharSequence)("projectPath: " + this.projectPath));
        this.getLog().debug((CharSequence)("androidResPath: " + this.androidResPath));
        this.getLog().debug((CharSequence)("androidManifestPath: " + this.androidManifestPath));
        if (this.projectPath == null) {
            this.projectPath = this.getDefaultProjectPath();
            this.getLog().debug((CharSequence)("projectPath set to Maven project basedir: " + this.projectPath));
        }
        DeveloperTools.setLogger((DeveloperTools.Logger)new MojoLogger((Mojo)this));
        DeveloperToolsUtils.cleanupResourceFile(this.projectPath, this.androidResPath, this.androidManifestPath);
        DeveloperToolsUtils.uploadDeobsFiles(this.projectPath, this.androidResPath, this.androidManifestPath);
        DeveloperToolsUtils.generateResourceFile(this.projectPath, this.androidResPath, this.androidManifestPath);
    }
}

