/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.dependency;

import com.crashlytics.dependency.ModuleResolver;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.LinkedList;
import java.util.List;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.module.descriptor.DefaultExcludeRule;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ArtifactId;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.matcher.ExactPatternMatcher;
import org.apache.ivy.plugins.resolver.ChainResolver;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.plugins.resolver.IBiblioResolver;
import org.apache.ivy.plugins.resolver.URLResolver;
import org.apache.ivy.util.url.CredentialsStore;
import org.apache.ivy.util.url.URLHandler;
import org.apache.ivy.util.url.URLHandlerDispatcher;
import org.apache.ivy.util.url.URLHandlerRegistry;

public class IvyModuleResolver
implements ModuleResolver {
    private static final String MAVEN_CENTRAL_URL = "http://central.maven.org/maven2";
    private static final DefaultExcludeRule EXCLUDE_APP_SUPPORT_LIBRARY = new DefaultExcludeRule(new ArtifactId(new ModuleId("com.crashlytics.reloc.com.android.support", "support-v4"), "*", "*", "*"), ExactPatternMatcher.INSTANCE, null);
    private final Ivy _ivy;

    public IvyModuleResolver(Ivy ivy) {
        this._ivy = ivy;
    }

    public static IvyModuleResolver createPublicResolver(String name, String repository) {
        return new IvyModuleResolver(IvyModuleResolver.getIvy(IvyModuleResolver.getIBiblioResolver(name, repository)));
    }

    public static IvyModuleResolver createAuthenticatedResolver(String name, String repository, String username, String password, String root) {
        IvyModuleResolver.configureURLHandler(name, repository, username, password);
        return new IvyModuleResolver(IvyModuleResolver.getIvy(IvyModuleResolver.getIBiblioResolver(name, root)));
    }

    public static IvyModuleResolver createMavenCentralBackedAuthenticatedResolver(String name, String repository, String username, String password, String root) {
        IvyModuleResolver.configureURLHandler(name, repository, username, password);
        return new IvyModuleResolver(IvyModuleResolver.getIvy(IvyModuleResolver.getChainResolver(IvyModuleResolver.getIBiblioResolver(name, root), IvyModuleResolver.getIBiblioResolver("maven", MAVEN_CENTRAL_URL))));
    }

    public static void configureURLHandler(String realm, String host, String username, String password) {
        CredentialsStore.INSTANCE.addCredentials(realm, host, username, password);
        URLHandlerDispatcher dispatcher = new URLHandlerDispatcher();
        URLHandler httpHandler = URLHandlerRegistry.getHttp();
        dispatcher.setDownloader("http", httpHandler);
        dispatcher.setDownloader("https", httpHandler);
        URLHandlerRegistry.setDefault(dispatcher);
    }

    private static ChainResolver getChainResolver(DependencyResolver ... resolvers) {
        ChainResolver chainResolver = new ChainResolver();
        for (DependencyResolver resolver : resolvers) {
            chainResolver.add(resolver);
        }
        return chainResolver;
    }

    private static URLResolver getIBiblioResolver(String name, String repositoryUrl) {
        IBiblioResolver resolver = new IBiblioResolver();
        resolver.setM2compatible(true);
        resolver.setName(name);
        resolver.setRoot(repositoryUrl);
        return resolver;
    }

    private static Ivy getIvy(DependencyResolver resolver) {
        IvySettings ivySettings = new IvySettings();
        ivySettings.addResolver(resolver);
        ivySettings.setDefaultResolver(resolver.getName());
        return Ivy.newInstance(ivySettings);
    }

    public ResolveReport resolveModules(ModuleRevisionId[] moduleRevisions) throws IOException, ParseException {
        ResolveOptions defaultOptions = new ResolveOptions();
        return this._ivy.resolve(this.getDescriptor(moduleRevisions, defaultOptions.isTransitive()), defaultOptions);
    }

    private ModuleDescriptor getDescriptor(ModuleRevisionId[] moduleRevisions, boolean transitivity) {
        DefaultModuleDescriptor caller = DefaultModuleDescriptor.newCallerInstance(moduleRevisions, transitivity, false);
        caller.addExcludeRule(EXCLUDE_APP_SUPPORT_LIBRARY);
        return caller;
    }

    @Override
    public List<File> resolveModulesFiles(ModuleRevisionId[] moduleRevisions) throws IOException {
        ResolveOptions defaultOptions = new ResolveOptions();
        ResolveReport report = null;
        try {
            report = this._ivy.resolve(this.getDescriptor(moduleRevisions, defaultOptions.isTransitive()), defaultOptions);
        }
        catch (ParseException e) {
            throw new IOException("Could not resolve modules", e);
        }
        LinkedList<File> resolvedFilesByModule = new LinkedList<File>();
        for (ArtifactDownloadReport artifactReport : report.getAllArtifactsReports()) {
            File localFile = artifactReport.getLocalFile();
            resolvedFilesByModule.add(localFile);
        }
        return resolvedFilesByModule;
    }

    static {
        EXCLUDE_APP_SUPPORT_LIBRARY.addConfiguration("default");
    }
}

