/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.com.android.sdklib.internal.repository;

import com.crashlytics.reloc.com.android.sdklib.internal.repository.Archive;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.IMinToolsDependency;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.Package;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.SdkSource;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.XmlParserUtils;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MinToolsPackage
extends Package
implements IMinToolsDependency {
    private final int mMinToolsRevision;

    MinToolsPackage(SdkSource sdkSource, Node node, String string, Map<String, String> map) {
        super(sdkSource, node, string, map);
        this.mMinToolsRevision = XmlParserUtils.getXmlInt(node, "min-tools-rev", 0);
    }

    public MinToolsPackage(SdkSource sdkSource, Properties properties, int n, String string, String string2, String string3, Archive.Os os, Archive.Arch arch, String string4) {
        super(sdkSource, properties, n, string, string2, string3, os, arch, string4);
        this.mMinToolsRevision = Integer.parseInt(MinToolsPackage.getProperty(properties, "Platform.MinToolsRev", Integer.toString(0)));
    }

    @Override
    public int getMinToolsRevision() {
        return this.mMinToolsRevision;
    }

    @Override
    void saveProperties(Properties properties) {
        super.saveProperties(properties);
        if (this.getMinToolsRevision() != 0) {
            properties.setProperty("Platform.MinToolsRev", Integer.toString(this.getMinToolsRevision()));
        }
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + this.mMinToolsRevision;
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof MinToolsPackage)) {
            return false;
        }
        MinToolsPackage minToolsPackage = (MinToolsPackage)object;
        return this.mMinToolsRevision == minToolsPackage.mMinToolsRevision;
    }
}

