/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.com.android.sdklib.internal.repository;

import com.crashlytics.reloc.com.android.sdklib.SdkConstants;
import com.crashlytics.reloc.com.android.sdklib.SdkManager;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.AdbWrapper;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.Archive;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.BrokenPackage;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.ITaskMonitor;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.Package;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.SdkSource;
import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlatformToolPackage
extends Package {
    public static final String INSTALL_ID = "platform-tools";

    PlatformToolPackage(SdkSource sdkSource, Node node, String string, Map<String, String> map) {
        super(sdkSource, node, string, map);
    }

    static Package create(SdkSource sdkSource, Properties properties, int n, String string, String string2, String string3, Archive.Os os, Archive.Arch arch, String string4) {
        Object object;
        Object object2;
        PlatformToolPackage platformToolPackage = new PlatformToolPackage(sdkSource, properties, n, string, string2, string3, os, arch, string4);
        File file = new File(string4);
        String string5 = null;
        if (!file.isDirectory()) {
            string5 = "platform-tools folder is missing";
        } else {
            object2 = file.listFiles();
            if (object2 == null || ((File[])object2).length == 0) {
                string5 = "platform-tools folder is empty";
            } else {
                object = new HashSet<String>();
                for (File file2 : object2) {
                    object.add(file2.getName());
                }
                for (String string6 : new String[]{SdkConstants.FN_ADB, SdkConstants.FN_AAPT, SdkConstants.FN_AIDL, SdkConstants.FN_DX}) {
                    if (object.contains(string6)) continue;
                    string5 = string5 == null ? "platform-tools folder is missing " : string5 + ", ";
                    string5 = string5 + string6;
                }
            }
        }
        if (string5 != null) {
            object2 = platformToolPackage.getShortDescription() + " [*]";
            object = String.format("Broken Platform-Tools Package: %1$s\n[*] Package cannot be used due to error: %2$s", string2, string5);
            BrokenPackage brokenPackage = new BrokenPackage(properties, (String)object2, (String)object, 0, 0, string4);
            return brokenPackage;
        }
        return platformToolPackage;
    }

    protected PlatformToolPackage(SdkSource sdkSource, Properties properties, int n, String string, String string2, String string3, Archive.Os os, Archive.Arch arch, String string4) {
        super(sdkSource, properties, n, string, string2, string3, os, arch, string4);
    }

    @Override
    public String installId() {
        return INSTALL_ID;
    }

    @Override
    public String getListDescription() {
        return String.format("Android SDK Platform-tools%1$s", this.isObsolete() ? " (Obsolete)" : "");
    }

    @Override
    public String getShortDescription() {
        return String.format("Android SDK Platform-tools, revision %1$d%2$s", this.getRevision(), this.isObsolete() ? " (Obsolete)" : "");
    }

    @Override
    public String getLongDescription() {
        String string = this.getDescription();
        if (string == null || string.length() == 0) {
            string = this.getShortDescription();
        }
        if (string.indexOf("revision") == -1) {
            string = string + String.format("\nRevision %1$d%2$s", this.getRevision(), this.isObsolete() ? " (Obsolete)" : "");
        }
        return string;
    }

    @Override
    public File getInstallFolder(String string, SdkManager sdkManager) {
        return new File(string, INSTALL_ID);
    }

    @Override
    public boolean sameItemAs(Package package_) {
        return package_ instanceof PlatformToolPackage;
    }

    @Override
    public boolean preInstallHook(Archive archive, ITaskMonitor iTaskMonitor, String string, File file) {
        AdbWrapper adbWrapper = new AdbWrapper(string, iTaskMonitor);
        adbWrapper.stopAdb();
        return super.preInstallHook(archive, iTaskMonitor, string, file);
    }
}

