/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.project;

import com.crashlytics.api.AuthenticationException;
import com.crashlytics.api.Organization;
import com.crashlytics.api.WebApi;
import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.android.project.CrashlyticsPropertiesBuilder;
import java.io.IOException;

public class BuildSecretMaintainer {
    private String _buildSecret;
    private WebApi _api;
    private String _apiKey;
    private final CrashlyticsPropertiesBuilder _propertyBuilder;

    public BuildSecretMaintainer(WebApi api, String apiKey, String buildSecret, CrashlyticsPropertiesBuilder propertyBuilder) {
        this._api = api;
        this._apiKey = apiKey;
        this._buildSecret = buildSecret;
        this._propertyBuilder = propertyBuilder;
    }

    public void maintainBuildSecret() throws IOException {
        try {
            Organization org;
            if (this._api != null && (org = this._api.getOrg(this._apiKey)) != null && org.getBuildSecret() != null) {
                this._buildSecret = org.getBuildSecret();
            }
        }
        catch (AuthenticationException e) {
            // empty catch block
        }
        if (this._buildSecret != null) {
            try {
                this._propertyBuilder.addBuildSecret(this._buildSecret).write();
            }
            catch (IOException io) {
                DeveloperTools.logW("Crashlytics was unable to write property", io);
            }
        }
    }

    public String getBuildSecret() {
        return this._buildSecret;
    }
}

