/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.project.library;

import com.crashlytics.dependency.IvyModuleResolver;
import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.android.onboard.OnboardingConstants;
import com.crashlytics.tools.android.project.library.AndroidLibrary;
import com.crashlytics.tools.android.project.library.AndroidLibraryGraph;
import com.crashlytics.tools.utils.SparseDirectedGraph;
import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;

public class AndroidLibraryGraphFactory {
    public static String IVY_MAVEN_URL = "https://twittersdk.artifactoryonline.com/twittersdk/repo";

    public static ResolveReport getDefaultResolution(ModuleRevisionId[] kits) throws IOException, ParseException, DependencyException {
        return IvyModuleResolver.createMavenCentralBackedAuthenticatedResolver("Artifactory Realm", "twittersdk.artifactoryonline.com", OnboardingConstants.TWITTER_SDK_REPOSITORY.getUsername(), OnboardingConstants.TWITTER_SDK_REPOSITORY.getPassword(), IVY_MAVEN_URL).resolveModules(kits);
    }

    public static AndroidLibraryGraph getLibraries(ResolveReport report, ModuleRevisionId[] requestedLibraries) throws DependencyException {
        DeveloperTools.logD("Resolution: " + report.getArtifacts());
        if (report.getUnresolvedDependencies().length > 0) {
            throw new DependencyException("Crashlytics found " + report.getUnresolvedDependencies().length + " unresolved dependencies.");
        }
        Map<ModuleRevisionId, ModuleRevisionId> revisionResolutions = AndroidLibraryGraphFactory.resolveIds(report);
        Map<ModuleRevisionId, List<ModuleRevisionId>> revisionDependencies = AndroidLibraryGraphFactory.getDependencyList(revisionResolutions, report);
        Map<ModuleRevisionId, AndroidLibrary> revisionLibraries = AndroidLibraryGraphFactory.getAndroidLibraries(revisionResolutions, report.getAllArtifactsReports());
        Map<AndroidLibrary, Set<AndroidLibrary>> libraryDependencies = AndroidLibraryGraphFactory.setupDependencies(revisionLibraries, revisionDependencies);
        List<AndroidLibrary> rootLibraries = AndroidLibraryGraphFactory.getRootLibraries(revisionResolutions, revisionLibraries, requestedLibraries);
        return new AndroidLibraryGraph(new SparseDirectedGraph<AndroidLibrary>(libraryDependencies), rootLibraries);
    }

    private static Map<ModuleRevisionId, ModuleRevisionId> resolveIds(ResolveReport report) {
        HashMap<ModuleRevisionId, ModuleRevisionId> revisionResolutions = new HashMap<ModuleRevisionId, ModuleRevisionId>();
        for (Object o : report.getDependencies()) {
            IvyNode node = (IvyNode)o;
            ModuleRevisionId id = node.getId();
            ResolvedModuleRevision resolvedId = node.getModuleRevision();
            DeveloperTools.logD("Id: " + id + " resolved as: " + resolvedId);
            revisionResolutions.put(id, resolvedId.getId());
        }
        for (ArtifactDownloadReport ar : report.getAllArtifactsReports()) {
            ModuleRevisionId id = ar.getArtifact().getModuleRevisionId();
            if (revisionResolutions.containsKey(id)) continue;
            revisionResolutions.put(ar.getArtifact().getModuleRevisionId(), ar.getArtifact().getModuleRevisionId());
        }
        return revisionResolutions;
    }

    public static Map<ModuleRevisionId, List<ModuleRevisionId>> getDependencyList(Map<ModuleRevisionId, ModuleRevisionId> revisionResolutions, ResolveReport report) {
        HashMap<ModuleRevisionId, List<ModuleRevisionId>> dependencyList = new HashMap<ModuleRevisionId, List<ModuleRevisionId>>();
        for (Object o : report.getDependencies()) {
            DependencyDescriptor[] dependencies;
            IvyNode node = (IvyNode)o;
            LinkedList<ModuleRevisionId> list = new LinkedList<ModuleRevisionId>();
            dependencyList.put(node.getModuleRevision().getId(), list);
            for (DependencyDescriptor desc : dependencies = node.getDescriptor().getDependencies()) {
                ModuleRevisionId unresolvedDependencyId = desc.getDependencyRevisionId();
                ModuleRevisionId resolvedDependencyId = revisionResolutions.get(unresolvedDependencyId);
                if (resolvedDependencyId == null) {
                    DeveloperTools.logD("Crashlytics found a dependency without an identified resolved ID: " + unresolvedDependencyId);
                    continue;
                }
                list.add(resolvedDependencyId);
            }
        }
        return dependencyList;
    }

    public static Map<ModuleRevisionId, AndroidLibrary> getAndroidLibraries(Map<ModuleRevisionId, ModuleRevisionId> revisionResolutions, ArtifactDownloadReport[] artifactReports) {
        HashMap<ModuleRevisionId, AndroidLibrary> revisionLibraries = new HashMap<ModuleRevisionId, AndroidLibrary>();
        for (ArtifactDownloadReport ar : artifactReports) {
            ModuleRevisionId resolvedId = revisionResolutions.get(ar.getArtifact().getModuleRevisionId());
            if (ar.getArtifact().getType().equals("javadoc") || !ar.getExt().equals("aar") && revisionLibraries.containsKey(resolvedId)) continue;
            revisionLibraries.put(resolvedId, new AndroidLibrary(AndroidLibrary.getModuleName(resolvedId.getModuleId()), ar.getLocalFile(), resolvedId.getRevision(), ar.getArtifact().getPublicationDate().getTime()));
        }
        return revisionLibraries;
    }

    private static Map<AndroidLibrary, Set<AndroidLibrary>> setupDependencies(Map<ModuleRevisionId, AndroidLibrary> revisionLibraries, Map<ModuleRevisionId, List<ModuleRevisionId>> revisionDependencies) throws DependencyException {
        HashMap<AndroidLibrary, Set<AndroidLibrary>> libraryDependencies = new HashMap<AndroidLibrary, Set<AndroidLibrary>>();
        for (Map.Entry<ModuleRevisionId, List<ModuleRevisionId>> libraryEntry : revisionDependencies.entrySet()) {
            HashSet<AndroidLibrary> libraries = new HashSet<AndroidLibrary>();
            for (ModuleRevisionId revision : libraryEntry.getValue()) {
                AndroidLibrary library = revisionLibraries.get(revision);
                if (library == null) {
                    throw new DependencyException("Crashlytics found a dependency without a resolved file." + revision);
                }
                libraries.add(library);
            }
            libraryDependencies.put(revisionLibraries.get(libraryEntry.getKey()), libraries);
        }
        return libraryDependencies;
    }

    public static List<AndroidLibrary> getRootLibraries(Map<ModuleRevisionId, ModuleRevisionId> revisionResolutions, Map<ModuleRevisionId, AndroidLibrary> revisionLibraries, ModuleRevisionId[] requestedLibraries) throws DependencyException {
        LinkedList<AndroidLibrary> rootLibraries = new LinkedList<AndroidLibrary>();
        for (ModuleRevisionId id : requestedLibraries) {
            ModuleRevisionId resolvedId = revisionResolutions.get(id);
            if (resolvedId == null) {
                throw new DependencyException("Crashlytics was not able to resolve " + id);
            }
            AndroidLibrary library = revisionLibraries.get(resolvedId);
            if (library == null) {
                throw new DependencyException("Crashlytics failed to identify the android library for a requested revision id: " + id);
            }
            rootLibraries.add(library);
        }
        return rootLibraries;
    }

    public static class DependencyException
    extends Exception {
        public DependencyException(String message) {
            super(message);
        }
    }
}

