/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.dependency.reloc.junit.runner;

import com.crashlytics.dependency.reloc.junit.framework.TestSuite;
import com.crashlytics.dependency.reloc.junit.runner.ClassPathTestCollector;
import com.crashlytics.dependency.reloc.junit.runner.TestCaseClassLoader;
import java.lang.reflect.Modifier;

public class LoadingTestCollector
extends ClassPathTestCollector {
    TestCaseClassLoader fLoader = new TestCaseClassLoader();
    static /* synthetic */ Class class$0;

    protected boolean isTestClass(String classFileName) {
        try {
            if (classFileName.endsWith(".class")) {
                Class testClass = this.classFromFile(classFileName);
                return testClass != null && this.isTestClass(testClass);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return false;
    }

    Class classFromFile(String classFileName) throws ClassNotFoundException {
        String className = this.classNameFromFile(classFileName);
        if (!this.fLoader.isExcluded(className)) {
            return this.fLoader.loadClass(className, false);
        }
        return null;
    }

    boolean isTestClass(Class testClass) {
        if (this.hasSuiteMethod(testClass)) {
            return true;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.crashlytics.dependency.reloc.junit.framework.Test");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz.isAssignableFrom(testClass) && Modifier.isPublic(testClass.getModifiers()) && this.hasPublicConstructor(testClass);
    }

    boolean hasSuiteMethod(Class testClass) {
        try {
            testClass.getMethod("suite", new Class[0]);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    boolean hasPublicConstructor(Class testClass) {
        try {
            TestSuite.getTestConstructor(testClass);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        return true;
    }
}

