/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.ftp;

import com.crashlytics.dependency.reloc.org.apache.commons.net.ftp.FTPClient;
import com.crashlytics.dependency.reloc.org.apache.commons.net.ftp.FTPFile;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystemException;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystemOptions;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.UserAuthenticationData;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.GenericFileName;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.ftp.FtpClient;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.ftp.FtpClientFactory;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.ftp.FtpFileProvider;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.util.UserAuthenticatorUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class FTPClientWrapper
implements FtpClient {
    private final GenericFileName root;
    private final FileSystemOptions fileSystemOptions;
    private FTPClient ftpClient = null;

    FTPClientWrapper(GenericFileName root, FileSystemOptions fileSystemOptions) throws FileSystemException {
        this.root = root;
        this.fileSystemOptions = fileSystemOptions;
        this.getFtpClient();
    }

    public GenericFileName getRoot() {
        return this.root;
    }

    public FileSystemOptions getFileSystemOptions() {
        return this.fileSystemOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FTPClient createClient() throws FileSystemException {
        FTPClient fTPClient;
        GenericFileName rootName = this.getRoot();
        UserAuthenticationData authData = null;
        try {
            authData = UserAuthenticatorUtils.authenticate(this.fileSystemOptions, FtpFileProvider.AUTHENTICATOR_TYPES);
            fTPClient = FtpClientFactory.createConnection(rootName.getHostName(), rootName.getPort(), UserAuthenticatorUtils.getData(authData, UserAuthenticationData.USERNAME, UserAuthenticatorUtils.toChar(rootName.getUserName())), UserAuthenticatorUtils.getData(authData, UserAuthenticationData.PASSWORD, UserAuthenticatorUtils.toChar(rootName.getPassword())), rootName.getPath(), this.getFileSystemOptions());
        }
        catch (Throwable throwable) {
            UserAuthenticatorUtils.cleanup(authData);
            throw throwable;
        }
        UserAuthenticatorUtils.cleanup(authData);
        return fTPClient;
    }

    private FTPClient getFtpClient() throws FileSystemException {
        if (this.ftpClient == null) {
            this.ftpClient = this.createClient();
        }
        return this.ftpClient;
    }

    public boolean isConnected() throws FileSystemException {
        return this.getFtpClient().isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() throws IOException {
        try {
            this.getFtpClient().disconnect();
        }
        finally {
            this.ftpClient = null;
        }
    }

    public FTPFile[] listFiles(String relPath) throws IOException {
        try {
            return this.getFtpClient().listFiles(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpClient().listFiles(relPath);
        }
    }

    public boolean removeDirectory(String relPath) throws IOException {
        try {
            return this.getFtpClient().removeDirectory(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpClient().removeDirectory(relPath);
        }
    }

    public boolean deleteFile(String relPath) throws IOException {
        try {
            return this.getFtpClient().deleteFile(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpClient().deleteFile(relPath);
        }
    }

    public boolean rename(String oldName, String newName) throws IOException {
        try {
            return this.getFtpClient().rename(oldName, newName);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpClient().rename(oldName, newName);
        }
    }

    public boolean makeDirectory(String relPath) throws IOException {
        try {
            return this.getFtpClient().makeDirectory(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpClient().makeDirectory(relPath);
        }
    }

    public boolean completePendingCommand() throws IOException {
        if (this.ftpClient != null) {
            return this.getFtpClient().completePendingCommand();
        }
        return true;
    }

    public InputStream retrieveFileStream(String relPath) throws IOException {
        try {
            return this.getFtpClient().retrieveFileStream(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpClient().retrieveFileStream(relPath);
        }
    }

    public InputStream retrieveFileStream(String relPath, long restartOffset) throws IOException {
        try {
            FTPClient client = this.getFtpClient();
            client.setRestartOffset(restartOffset);
            return client.retrieveFileStream(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            FTPClient client = this.getFtpClient();
            client.setRestartOffset(restartOffset);
            return client.retrieveFileStream(relPath);
        }
    }

    public OutputStream appendFileStream(String relPath) throws IOException {
        try {
            return this.getFtpClient().appendFileStream(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpClient().appendFileStream(relPath);
        }
    }

    public OutputStream storeFileStream(String relPath) throws IOException {
        try {
            return this.getFtpClient().storeFileStream(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpClient().storeFileStream(relPath);
        }
    }

    public boolean abort() throws IOException {
        try {
            this.disconnect();
            return true;
        }
        catch (IOException e) {
            this.disconnect();
            return true;
        }
    }

    public String getReplyString() throws IOException {
        return this.getFtpClient().getReplyString();
    }
}

