/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.ftp;

import com.crashlytics.dependency.reloc.org.apache.commons.vfs.Capability;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileName;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystem;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystemConfigBuilder;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystemException;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystemOptions;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.UserAuthenticationData;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.AbstractOriginatingFileProvider;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.GenericFileName;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.ftp.FTPClientWrapper;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.ftp.FtpFileNameParser;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.ftp.FtpFileSystem;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.ftp.FtpFileSystemConfigBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public class FtpFileProvider
extends AbstractOriginatingFileProvider {
    public static final String ATTR_FILE_ENTRY_PARSER = "FEP";
    static final Collection capabilities = Collections.unmodifiableCollection(Arrays.asList(Capability.CREATE, Capability.DELETE, Capability.RENAME, Capability.GET_TYPE, Capability.LIST_CHILDREN, Capability.READ_CONTENT, Capability.GET_LAST_MODIFIED, Capability.URI, Capability.WRITE_CONTENT, Capability.APPEND_CONTENT, Capability.RANDOM_ACCESS_READ));
    public static final UserAuthenticationData.Type[] AUTHENTICATOR_TYPES = new UserAuthenticationData.Type[]{UserAuthenticationData.USERNAME, UserAuthenticationData.PASSWORD};

    public FtpFileProvider() {
        this.setFileNameParser(FtpFileNameParser.getInstance());
    }

    protected FileSystem doCreateFileSystem(FileName name, FileSystemOptions fileSystemOptions) throws FileSystemException {
        GenericFileName rootName = (GenericFileName)name;
        FTPClientWrapper ftpClient = new FTPClientWrapper(rootName, fileSystemOptions);
        return new FtpFileSystem(rootName, ftpClient, fileSystemOptions);
    }

    public FileSystemConfigBuilder getConfigBuilder() {
        return FtpFileSystemConfigBuilder.getInstance();
    }

    public Collection getCapabilities() {
        return capabilities;
    }
}

