/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.http;

import com.crashlytics.dependency.reloc.org.apache.commons.httpclient.Header;
import com.crashlytics.dependency.reloc.org.apache.commons.httpclient.HeaderElement;
import com.crashlytics.dependency.reloc.org.apache.commons.httpclient.HttpException;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileContent;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileContentInfo;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileContentInfoFactory;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystemException;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.impl.DefaultFileContentInfo;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.http.HttpFileObject;

public class HttpFileContentInfoFactory
implements FileContentInfoFactory {
    public FileContentInfo create(FileContent fileContent) throws FileSystemException {
        HttpFileObject httpFile = (HttpFileObject)fileContent.getFile();
        String contentType = null;
        String contentEncoding = null;
        Header header = httpFile.getHeadMethod().getResponseHeader("content-type");
        if (header != null) {
            HeaderElement[] element;
            try {
                element = header.getValues();
            }
            catch (HttpException e) {
                throw new FileSystemException(e);
            }
            if (element != null && element.length > 0) {
                contentType = element[0].getName();
            }
        }
        contentEncoding = httpFile.getHeadMethod().getResponseCharSet();
        return new DefaultFileContentInfo(contentType, contentEncoding);
    }
}

