/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.jar;

import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileContent;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystemException;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.jar.JarFileObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.Certificate;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class JarURLConnectionImpl
extends JarURLConnection {
    private static final String HACK_URL = "jar:http://somehost/somejar.jar!/";
    private FileContent content;
    private URL parentURL;
    private JarFileObject file;
    private String entryName;

    public JarURLConnectionImpl(JarFileObject file, FileContent content) throws MalformedURLException, FileSystemException {
        super(new URL(HACK_URL));
        this.url = file.getURL();
        this.content = content;
        this.parentURL = file.getURL();
        this.entryName = file.getName().getPath();
        this.file = file;
    }

    public URL getJarFileURL() {
        return this.parentURL;
    }

    public String getEntryName() {
        return this.entryName;
    }

    public JarFile getJarFile() throws IOException {
        throw new FileSystemException("vfs.provider.jar/jar-file-no-access.error");
    }

    public Manifest getManifest() throws IOException {
        return this.file.getManifest();
    }

    public JarEntry getJarEntry() throws IOException {
        throw new FileSystemException("vfs.provider.jar/jar-entry-no-access.error");
    }

    public Attributes getAttributes() throws IOException {
        return this.file.getAttributes();
    }

    public Certificate[] getCertificates() {
        return this.file.doGetCertificates();
    }

    public void connect() {
        this.connected = true;
    }

    public InputStream getInputStream() throws IOException {
        return this.content.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.content.getOutputStream();
    }

    public int getContentLength() {
        try {
            return (int)this.content.getSize();
        }
        catch (FileSystemException fileSystemException) {
            return -1;
        }
    }
}

