/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.local;

import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileName;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileObject;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSelector;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystem;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystemException;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystemOptions;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.AbstractFileSystem;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.local.DefaultLocalFileProvider;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.local.LocalFile;
import java.io.File;
import java.io.FilePermission;
import java.util.Collection;

public class LocalFileSystem
extends AbstractFileSystem
implements FileSystem {
    private final String rootFile;

    public LocalFileSystem(FileName rootName, String rootFile, FileSystemOptions opts) {
        super(rootName, null, opts);
        this.rootFile = rootFile;
    }

    protected FileObject createFile(FileName name) throws FileSystemException {
        return new LocalFile(this, this.rootFile, name);
    }

    protected void addCapabilities(Collection caps) {
        caps.addAll(DefaultLocalFileProvider.capabilities);
    }

    protected File doReplicateFile(FileObject fileObject, FileSelector selector) throws Exception {
        LocalFile localFile = (LocalFile)fileObject;
        File file = localFile.getLocalFile();
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            FilePermission requiredPerm = new FilePermission(file.getAbsolutePath(), "read");
            sm.checkPermission(requiredPerm);
        }
        return file;
    }
}

