/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.tar;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

class TarBuffer {
    public static final int DEFAULT_RECORDSIZE = 512;
    public static final int DEFAULT_BLOCKSIZE = 10240;
    private byte[] m_blockBuffer;
    private int m_blockSize;
    private int m_currBlkIdx;
    private int m_currRecIdx;
    private boolean m_debug;
    private InputStream m_input;
    private OutputStream m_output;
    private int m_recordSize;
    private int m_recsPerBlock;

    TarBuffer(InputStream input) {
        this(input, 10240);
    }

    TarBuffer(InputStream input, int blockSize) {
        this(input, blockSize, 512);
    }

    TarBuffer(InputStream input, int blockSize, int recordSize) {
        this.m_input = input;
        this.initialize(blockSize, recordSize);
    }

    TarBuffer(OutputStream output) {
        this(output, 10240);
    }

    TarBuffer(OutputStream output, int blockSize) {
        this(output, blockSize, 512);
    }

    TarBuffer(OutputStream output, int blockSize, int recordSize) {
        this.m_output = output;
        this.initialize(blockSize, recordSize);
    }

    public void setDebug(boolean debug) {
        this.m_debug = debug;
    }

    public int getBlockSize() {
        return this.m_blockSize;
    }

    public int getCurrentBlockNum() {
        return this.m_currBlkIdx;
    }

    public int getCurrentRecordNum() {
        return this.m_currRecIdx - 1;
    }

    public int getRecordSize() {
        return this.m_recordSize;
    }

    public boolean isEOFRecord(byte[] record) {
        int size = this.getRecordSize();
        for (int i = 0; i < size; ++i) {
            if (record[i] == 0) continue;
            return false;
        }
        return true;
    }

    public void close() throws IOException {
        if (this.m_debug) {
            this.debug("TarBuffer.closeBuffer().");
        }
        if (null != this.m_output) {
            this.flushBlock();
            if (this.m_output != System.out && this.m_output != System.err) {
                this.m_output.close();
                this.m_output = null;
            }
        } else if (this.m_input != null && this.m_input != System.in) {
            this.m_input.close();
            this.m_input = null;
        }
    }

    public byte[] readRecord() throws IOException {
        String message;
        if (this.m_debug) {
            message = "ReadRecord: recIdx = " + this.m_currRecIdx + " blkIdx = " + this.m_currBlkIdx;
            this.debug(message);
        }
        if (null == this.m_input) {
            message = "reading from an output buffer";
            throw new IOException("reading from an output buffer");
        }
        if (this.m_currRecIdx >= this.m_recsPerBlock && !this.readBlock()) {
            return null;
        }
        byte[] result = new byte[this.m_recordSize];
        System.arraycopy(this.m_blockBuffer, this.m_currRecIdx * this.m_recordSize, result, 0, this.m_recordSize);
        ++this.m_currRecIdx;
        return result;
    }

    public void skipRecord() throws IOException {
        String message;
        if (this.m_debug) {
            message = "SkipRecord: recIdx = " + this.m_currRecIdx + " blkIdx = " + this.m_currBlkIdx;
            this.debug(message);
        }
        if (null == this.m_input) {
            message = "reading (via skip) from an output buffer";
            throw new IOException("reading (via skip) from an output buffer");
        }
        if (this.m_currRecIdx >= this.m_recsPerBlock && !this.readBlock()) {
            return;
        }
        ++this.m_currRecIdx;
    }

    public void writeRecord(byte[] record) throws IOException {
        String message;
        if (this.m_debug) {
            message = "WriteRecord: recIdx = " + this.m_currRecIdx + " blkIdx = " + this.m_currBlkIdx;
            this.debug(message);
        }
        if (null == this.m_output) {
            message = "writing to an input buffer";
            throw new IOException("writing to an input buffer");
        }
        if (record.length != this.m_recordSize) {
            message = "record to write has length '" + record.length + "' which is not the record size of '" + this.m_recordSize + "'";
            throw new IOException(message);
        }
        if (this.m_currRecIdx >= this.m_recsPerBlock) {
            this.writeBlock();
        }
        System.arraycopy(record, 0, this.m_blockBuffer, this.m_currRecIdx * this.m_recordSize, this.m_recordSize);
        ++this.m_currRecIdx;
    }

    public void writeRecord(byte[] buffer, int offset) throws IOException {
        String message;
        if (this.m_debug) {
            message = "WriteRecord: recIdx = " + this.m_currRecIdx + " blkIdx = " + this.m_currBlkIdx;
            this.debug(message);
        }
        if (null == this.m_output) {
            message = "writing to an input buffer";
            throw new IOException("writing to an input buffer");
        }
        if (offset + this.m_recordSize > buffer.length) {
            message = "record has length '" + buffer.length + "' with offset '" + offset + "' which is less than the record size of '" + this.m_recordSize + "'";
            throw new IOException(message);
        }
        if (this.m_currRecIdx >= this.m_recsPerBlock) {
            this.writeBlock();
        }
        System.arraycopy(buffer, offset, this.m_blockBuffer, this.m_currRecIdx * this.m_recordSize, this.m_recordSize);
        ++this.m_currRecIdx;
    }

    private void flushBlock() throws IOException {
        String message;
        if (this.m_debug) {
            message = "TarBuffer.flushBlock() called.";
            this.debug("TarBuffer.flushBlock() called.");
        }
        if (this.m_output == null) {
            message = "writing to an input buffer";
            throw new IOException("writing to an input buffer");
        }
        if (this.m_currRecIdx > 0) {
            this.writeBlock();
        }
    }

    private void initialize(int blockSize, int recordSize) {
        this.m_debug = false;
        this.m_blockSize = blockSize;
        this.m_recordSize = recordSize;
        this.m_recsPerBlock = this.m_blockSize / this.m_recordSize;
        this.m_blockBuffer = new byte[this.m_blockSize];
        if (null != this.m_input) {
            this.m_currBlkIdx = -1;
            this.m_currRecIdx = this.m_recsPerBlock;
        } else {
            this.m_currBlkIdx = 0;
            this.m_currRecIdx = 0;
        }
    }

    private boolean readBlock() throws IOException {
        String message;
        if (this.m_debug) {
            message = "ReadBlock: blkIdx = " + this.m_currBlkIdx;
            this.debug(message);
        }
        if (null == this.m_input) {
            message = "reading from an output buffer";
            throw new IOException("reading from an output buffer");
        }
        this.m_currRecIdx = 0;
        int offset = 0;
        int bytesNeeded = this.m_blockSize;
        while (bytesNeeded > 0) {
            long numBytes = this.m_input.read(this.m_blockBuffer, offset, bytesNeeded);
            if (numBytes == -1L) {
                Arrays.fill(this.m_blockBuffer, offset, offset + bytesNeeded, (byte)0);
                break;
            }
            offset = (int)((long)offset + numBytes);
            bytesNeeded = (int)((long)bytesNeeded - numBytes);
            if (numBytes == (long)this.m_blockSize || !this.m_debug) continue;
            System.err.println("ReadBlock: INCOMPLETE READ " + numBytes + " of " + this.m_blockSize + " bytes read.");
        }
        ++this.m_currBlkIdx;
        return true;
    }

    private void writeBlock() throws IOException {
        String message;
        if (this.m_debug) {
            message = "WriteBlock: blkIdx = " + this.m_currBlkIdx;
            this.debug(message);
        }
        if (null == this.m_output) {
            message = "writing to an input buffer";
            throw new IOException("writing to an input buffer");
        }
        this.m_output.write(this.m_blockBuffer, 0, this.m_blockSize);
        this.m_output.flush();
        this.m_currRecIdx = 0;
        ++this.m_currBlkIdx;
    }

    protected void debug(String message) {
        if (this.m_debug) {
            System.err.println(message);
        }
    }
}

