/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.dependency.reloc.org.apache.commons.vfs.tasks;

import com.crashlytics.dependency.reloc.org.apache.commons.vfs.Capability;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileObject;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystemException;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.Selectors;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.tasks.AbstractSyncTask;

public class CopyTask
extends AbstractSyncTask {
    private boolean overwrite = false;
    private boolean preserveLastModified = true;

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void setPreserveLastModified(boolean preserveLastModified) {
        this.preserveLastModified = preserveLastModified;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public boolean isPreserveLastModified() {
        return this.preserveLastModified;
    }

    protected void handleOutOfDateFile(FileObject srcFile, FileObject destFile) throws FileSystemException {
        this.log("Copying " + srcFile + " to " + destFile);
        destFile.copyFrom(srcFile, Selectors.SELECT_SELF);
        if (this.preserveLastModified && srcFile.getFileSystem().hasCapability(Capability.GET_LAST_MODIFIED) && destFile.getFileSystem().hasCapability(Capability.SET_LAST_MODIFIED_FILE)) {
            long lastModTime = srcFile.getContent().getLastModifiedTime();
            destFile.getContent().setLastModifiedTime(lastModTime);
        }
    }

    protected void handleUpToDateFile(FileObject srcFile, FileObject destFile) throws FileSystemException {
        if (this.overwrite) {
            this.handleOutOfDateFile(srcFile, destFile);
        }
    }
}

