/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.com.android.sdklib.internal.repository;

import com.crashlytics.reloc.com.android.sdklib.IAndroidTarget;
import com.crashlytics.reloc.com.android.sdklib.ISdkLog;
import com.crashlytics.reloc.com.android.sdklib.ISystemImage;
import com.crashlytics.reloc.com.android.sdklib.SdkConstants;
import com.crashlytics.reloc.com.android.sdklib.SdkManager;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.AddonPackage;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.Archive;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.DocPackage;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.ExtraPackage;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.ITaskMonitor;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.Package;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.PlatformPackage;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.PlatformToolPackage;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.SamplePackage;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.SourcePackage;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.SystemImagePackage;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.ToolPackage;
import com.crashlytics.reloc.com.android.util.Pair;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalSdkParser {
    private Package[] mPackages;
    public static final int PARSE_ALL = 65535;
    public static final int PARSE_TOOLS = 1;
    public static final int PARSE_PLATFORM_TOOLS = 2;
    public static final int PARSE_DOCS = 4;
    public static final int PARSE_PLATFORMS = 16;
    public static final int PARSE_ADDONS = 32;
    public static final int PARSE_SAMPLES = 256;
    public static final int PARSE_SOURCES = 512;
    public static final int PARSE_EXTRAS = 1024;

    public Package[] getPackages() {
        return this.mPackages;
    }

    public void clearPackages() {
        this.mPackages = null;
    }

    public Package[] parseSdk(String string, SdkManager sdkManager, ITaskMonitor iTaskMonitor) {
        return this.parseSdk(string, sdkManager, 65535, iTaskMonitor);
    }

    public Package[] parseSdk(String string, SdkManager sdkManager, int n, ITaskMonitor iTaskMonitor) {
        ArrayList<Package> arrayList = new ArrayList<Package>();
        HashSet<File> hashSet = new HashSet<File>();
        iTaskMonitor.setProgressMax(10);
        File file = null;
        Package package_ = null;
        if ((n & 4) != 0 && (package_ = this.scanDoc(file = new File(string, "docs"), iTaskMonitor)) != null) {
            arrayList.add(package_);
            hashSet.add(file);
        }
        iTaskMonitor.incProgress(1);
        if ((n & 1) != 0 && (package_ = this.scanTools(file = new File(string, "tools"), iTaskMonitor)) != null) {
            arrayList.add(package_);
            hashSet.add(file);
        }
        iTaskMonitor.incProgress(1);
        if ((n & 2) != 0 && (package_ = this.scanPlatformTools(file = new File(string, "platform-tools"), iTaskMonitor)) != null) {
            arrayList.add(package_);
            hashSet.add(file);
        }
        iTaskMonitor.incProgress(1);
        if ((n & 0x30) != 0) {
            File file2 = new File(string, "samples");
            for (IAndroidTarget iAndroidTarget : sdkManager.getTargets()) {
                Properties properties = this.parseProperties(new File(iAndroidTarget.getLocation(), "source.properties"));
                try {
                    Object object;
                    package_ = null;
                    if (iAndroidTarget.isPlatform() && (n & 0x10) != 0) {
                        package_ = PlatformPackage.create(iAndroidTarget, properties);
                        if (file2.isDirectory() && ((File)(object = new File(iAndroidTarget.getPath(4)))).exists() && ((File)object).getParentFile().equals(file2)) {
                            Properties properties2 = this.parseProperties(new File((File)object, "source.properties"));
                            if (properties2 != null) {
                                Package package_2 = SamplePackage.create(iAndroidTarget, properties2);
                                arrayList.add(package_2);
                            }
                            hashSet.add((File)object);
                        }
                    } else if ((n & 0x20) != 0) {
                        package_ = AddonPackage.create(iAndroidTarget, properties);
                    }
                    if (package_ != null) {
                        object = iAndroidTarget.getSystemImages();
                        int n2 = ((ISystemImage[])object).length;
                        for (int i = 0; i < n2; ++i) {
                            File file3;
                            Object object2 = object[i];
                            if (object2.getLocationType() != ISystemImage.LocationType.IN_SYSTEM_IMAGE || !(file3 = object2.getLocation()).isDirectory()) continue;
                            Properties properties3 = this.parseProperties(new File(file3, "source.properties"));
                            SystemImagePackage systemImagePackage = new SystemImagePackage(iAndroidTarget.getVersion(), 0, object2.getAbiType(), properties3, file3.getAbsolutePath());
                            arrayList.add(systemImagePackage);
                            hashSet.add(file3);
                        }
                    }
                }
                catch (Exception exception) {
                    iTaskMonitor.error(exception, null, new Object[0]);
                }
                if (package_ == null) continue;
                arrayList.add(package_);
                hashSet.add(new File(iAndroidTarget.getLocation()));
            }
        }
        iTaskMonitor.incProgress(1);
        if ((n & 0x10) != 0) {
            this.scanMissingSystemImages(sdkManager, hashSet, arrayList, iTaskMonitor);
        }
        iTaskMonitor.incProgress(1);
        if ((n & 0x20) != 0) {
            this.scanMissingAddons(sdkManager, hashSet, arrayList, iTaskMonitor);
        }
        iTaskMonitor.incProgress(1);
        if ((n & 0x100) != 0) {
            this.scanMissingSamples(sdkManager, hashSet, arrayList, iTaskMonitor);
        }
        iTaskMonitor.incProgress(1);
        if ((n & 0x400) != 0) {
            this.scanExtras(sdkManager, hashSet, arrayList, iTaskMonitor);
        }
        iTaskMonitor.incProgress(1);
        if ((n & 0x400) != 0) {
            this.scanExtrasDirectory(string, hashSet, arrayList, iTaskMonitor);
        }
        iTaskMonitor.incProgress(1);
        if ((n & 0x200) != 0) {
            this.scanSources(sdkManager, hashSet, arrayList, iTaskMonitor);
        }
        iTaskMonitor.incProgress(1);
        Collections.sort(arrayList);
        this.mPackages = arrayList.toArray(new Package[arrayList.size()]);
        return this.mPackages;
    }

    private void scanExtras(SdkManager sdkManager, HashSet<File> hashSet, ArrayList<Package> arrayList, ISdkLog iSdkLog) {
        File file = new File(sdkManager.getLocation(), "extras");
        if (!file.isDirectory()) {
            return;
        }
        for (File file2 : file.listFiles()) {
            if (!file2.isDirectory()) continue;
            this.scanExtrasDirectory(file2.getAbsolutePath(), hashSet, arrayList, iSdkLog);
        }
    }

    private void scanExtrasDirectory(String string, HashSet<File> hashSet, ArrayList<Package> arrayList, ISdkLog iSdkLog) {
        File file = new File(string);
        if (!file.isDirectory()) {
            return;
        }
        for (File file2 : file.listFiles()) {
            Properties properties;
            if (!file2.isDirectory() || hashSet.contains(file2) || (properties = this.parseProperties(new File(file2, "source.properties"))) == null) continue;
            try {
                Package package_ = ExtraPackage.create(null, properties, null, file2.getName(), 0, null, null, null, Archive.Os.getCurrentOs(), Archive.Arch.getCurrentArch(), file2.getPath());
                arrayList.add(package_);
                hashSet.add(file2);
            }
            catch (Exception exception) {
                iSdkLog.error(exception, null, new Object[0]);
            }
        }
    }

    private void scanMissingSamples(SdkManager sdkManager, HashSet<File> hashSet, ArrayList<Package> arrayList, ISdkLog iSdkLog) {
        File file = new File(sdkManager.getLocation());
        if (!(file = new File(file, "samples")).isDirectory()) {
            return;
        }
        for (File file2 : file.listFiles()) {
            Properties properties;
            if (!file2.isDirectory() || hashSet.contains(file2) || (properties = this.parseProperties(new File(file2, "source.properties"))) == null) continue;
            try {
                Package package_ = SamplePackage.create(file2.getAbsolutePath(), properties);
                arrayList.add(package_);
                hashSet.add(file2);
            }
            catch (Exception exception) {
                iSdkLog.error(exception, null, new Object[0]);
            }
        }
    }

    private void scanMissingAddons(SdkManager sdkManager, HashSet<File> hashSet, ArrayList<Package> arrayList, ISdkLog iSdkLog) {
        File file = new File(new File(sdkManager.getLocation()), "add-ons");
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            if (!file2.isDirectory() || hashSet.contains(file2)) continue;
            Pair<Map<String, String>, String> pair = SdkManager.parseAddonProperties(file2, sdkManager.getTargets(), iSdkLog);
            Properties properties = this.parseProperties(new File(file2, "source.properties"));
            Map<String, String> map = pair.getFirst();
            String string = pair.getSecond();
            try {
                Package package_ = AddonPackage.createBroken(file2.getAbsolutePath(), properties, map, string);
                arrayList.add(package_);
                hashSet.add(file2);
            }
            catch (Exception exception) {
                iSdkLog.error(exception, null, new Object[0]);
            }
        }
    }

    private void scanMissingSystemImages(SdkManager sdkManager, HashSet<File> hashSet, ArrayList<Package> arrayList, ISdkLog iSdkLog) {
        File file = new File(sdkManager.getLocation(), "system-images");
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            if (!file2.isDirectory() || hashSet.contains(file2)) continue;
            hashSet.add(file2);
            File[] fileArray2 = file2.listFiles();
            if (fileArray2 == null) continue;
            for (File file3 : fileArray2) {
                if (!file3.isDirectory() || hashSet.contains(file3)) continue;
                hashSet.add(file3);
                File[] fileArray3 = file3.listFiles();
                if (fileArray3 == null || fileArray3.length <= 0) continue;
                Properties properties = this.parseProperties(new File(file3, "source.properties"));
                try {
                    Package package_ = SystemImagePackage.createBroken(file3, properties);
                    arrayList.add(package_);
                }
                catch (Exception exception) {
                    iSdkLog.error(exception, null, new Object[0]);
                }
            }
        }
    }

    private void scanSources(SdkManager sdkManager, HashSet<File> hashSet, ArrayList<Package> arrayList, ISdkLog iSdkLog) {
        File file = new File(sdkManager.getLocation(), "sources");
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            if (!file2.isDirectory() || hashSet.contains(file2)) continue;
            hashSet.add(file2);
            File[] fileArray2 = file2.listFiles();
            if (fileArray2 == null || fileArray2.length <= 0) continue;
            Properties properties = this.parseProperties(new File(file2, "source.properties"));
            try {
                Package package_ = SourcePackage.create(file2, properties);
                arrayList.add(package_);
            }
            catch (Exception exception) {
                iSdkLog.error(exception, null, new Object[0]);
            }
        }
    }

    private Package scanTools(File file, ISdkLog iSdkLog) {
        Properties properties = this.parseProperties(new File(file, "source.properties"));
        boolean bl = false;
        boolean bl2 = false;
        String string = SdkConstants.androidCmdName().replace(".bat", ".exe");
        String string2 = string.indexOf(46) == -1 ? null : string.replace(".exe", ".bat");
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                String string3 = file2.getName();
                if (SdkConstants.FN_EMULATOR.equals(string3)) {
                    bl = true;
                }
                if (!string.equals(string3) && (string2 == null || !string2.equals(string3))) continue;
                bl2 = true;
            }
        }
        if (!bl2 || !bl) {
            return null;
        }
        try {
            Package exception = ToolPackage.create(null, properties, 0, null, "Tools", null, Archive.Os.getCurrentOs(), Archive.Arch.getCurrentArch(), file.getPath());
            return exception;
        }
        catch (Exception exception) {
            iSdkLog.error(exception, null, new Object[0]);
            return null;
        }
    }

    private Package scanPlatformTools(File file, ISdkLog iSdkLog) {
        Properties properties = this.parseProperties(new File(file, "source.properties"));
        if (file.listFiles() == null) {
            return null;
        }
        try {
            Package package_ = PlatformToolPackage.create(null, properties, 0, null, "Platform Tools", null, Archive.Os.getCurrentOs(), Archive.Arch.getCurrentArch(), file.getPath());
            return package_;
        }
        catch (Exception exception) {
            iSdkLog.error(exception, null, new Object[0]);
            return null;
        }
    }

    private Package scanDoc(File file, ISdkLog iSdkLog) {
        Properties properties = this.parseProperties(new File(file, "source.properties"));
        if (new File(file, "index.html").isFile()) {
            try {
                Package package_ = DocPackage.create(null, properties, 0, null, 0, null, null, null, Archive.Os.getCurrentOs(), Archive.Arch.getCurrentArch(), file.getPath());
                return package_;
            }
            catch (Exception exception) {
                iSdkLog.error(exception, null, new Object[0]);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties parseProperties(File file) {
        FileInputStream fileInputStream = null;
        try {
            if (file.exists()) {
                fileInputStream = new FileInputStream(file);
                Properties properties = new Properties();
                properties.load(fileInputStream);
                if (properties.size() > 0) {
                    Properties properties2 = properties;
                    return properties2;
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }
}

