/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.com.android.sdklib.internal.repository;

import com.crashlytics.reloc.com.android.sdklib.AndroidVersion;
import com.crashlytics.reloc.com.android.sdklib.SdkManager;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.Archive;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.BrokenPackage;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.IPackageVersion;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.IPlatformDependency;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.Package;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.SdkSource;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.XmlParserUtils;
import java.io.File;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemImagePackage
extends Package
implements IPackageVersion,
IPlatformDependency {
    private final AndroidVersion mVersion;
    private final String mAbi;

    SystemImagePackage(SdkSource sdkSource, Node node, String string, Map<String, String> map) {
        super(sdkSource, node, string, map);
        int n = XmlParserUtils.getXmlInt(node, "api-level", 0);
        String string2 = XmlParserUtils.getXmlString(node, "codename");
        if (string2.length() == 0) {
            string2 = null;
        }
        this.mVersion = new AndroidVersion(n, string2);
        this.mAbi = XmlParserUtils.getXmlString(node, "abi");
    }

    protected SystemImagePackage(AndroidVersion androidVersion, int n, String string, Properties properties, String string2) {
        this(null, androidVersion, n, string, properties, string2);
    }

    protected SystemImagePackage(SdkSource sdkSource, AndroidVersion androidVersion, int n, String string, Properties properties, String string2) {
        super(sdkSource, properties, n, null, null, null, Archive.Os.getCurrentOs(), Archive.Arch.getCurrentArch(), string2);
        this.mVersion = androidVersion;
        if (string == null && properties != null) {
            string = properties.getProperty("SystemImage.Abi");
        }
        assert (string != null) : "To use this SystemImagePackage constructor you must pass an ABI as a parameter or as a PROP_ABI property";
        this.mAbi = string;
    }

    public static Package createBroken(File file, Properties properties) {
        CharSequence charSequence;
        AndroidVersion androidVersion = null;
        String string = file.getName();
        String string2 = null;
        if (properties == null) {
            string2 = String.format("Missing file %1$s", "source.properties");
        } else {
            try {
                androidVersion = new AndroidVersion(properties);
                charSequence = properties.getProperty("SystemImage.Abi");
                if (charSequence != null) {
                    string = charSequence;
                } else {
                    string2 = String.format("Invalid file %1$s: Missing property %2$s", "source.properties", "SystemImage.Abi");
                }
            }
            catch (AndroidVersion.AndroidVersionException androidVersionException) {
                string2 = String.format("Invalid file %1$s: %2$s", "source.properties", androidVersionException.getMessage());
            }
        }
        if (androidVersion == null) {
            try {
                charSequence = file.getParentFile().getName();
                charSequence = ((String)charSequence).replaceAll("[^0-9]+", " ").trim();
                int n = ((String)charSequence).indexOf(32);
                if (n >= 0) {
                    charSequence = ((String)charSequence).substring(0, n);
                }
                int n2 = Integer.parseInt((String)charSequence);
                androidVersion = new AndroidVersion(n2, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        charSequence = new StringBuilder(String.format("Broken %1$s System Image", SystemImagePackage.getAbiDisplayNameInternal(string)));
        if (androidVersion != null) {
            ((StringBuilder)charSequence).append(String.format(", API %1$s", androidVersion.getApiString()));
        }
        String string3 = ((StringBuilder)charSequence).toString();
        if (string2 != null) {
            ((StringBuilder)charSequence).append('\n').append(string2);
        }
        String string4 = ((StringBuilder)charSequence).toString();
        return new BrokenPackage(properties, string3, string4, 0, androidVersion == null ? 0 : androidVersion.getApiLevel(), file.getAbsolutePath());
    }

    @Override
    void saveProperties(Properties properties) {
        super.saveProperties(properties);
        this.mVersion.saveProperties(properties);
        properties.setProperty("SystemImage.Abi", this.mAbi);
    }

    public String getAbi() {
        return this.mAbi;
    }

    public String getAbiDisplayName() {
        return SystemImagePackage.getAbiDisplayNameInternal(this.mAbi);
    }

    private static String getAbiDisplayNameInternal(String string) {
        return string.replace("armeabi", "ARM EABI").replace("x86", "Intel x86 Atom").replace("mips", "Mips").replace("-", " ");
    }

    @Override
    public AndroidVersion getVersion() {
        return this.mVersion;
    }

    @Override
    public String installId() {
        return "sysimg-" + this.mVersion.getApiString();
    }

    @Override
    public String getListDescription() {
        return String.format("%1$s System Image%2$s", this.getAbiDisplayName(), this.isObsolete() ? " (Obsolete)" : "");
    }

    @Override
    public String getShortDescription() {
        return String.format("%1$s System Image, Android API %2$s, revision %3$s%4$s", this.getAbiDisplayName(), this.mVersion.getApiString(), this.getRevision(), this.isObsolete() ? " (Obsolete)" : "");
    }

    @Override
    public String getLongDescription() {
        String string = this.getDescription();
        if (string == null || string.length() == 0) {
            string = this.getShortDescription();
        }
        if (string.indexOf("revision") == -1) {
            string = string + String.format("\nRevision %1$d%2$s", this.getRevision(), this.isObsolete() ? " (Obsolete)" : "");
        }
        string = string + String.format("\nRequires SDK Platform Android API %1$s", this.mVersion.getApiString());
        return string;
    }

    @Override
    public File getInstallFolder(String string, SdkManager sdkManager) {
        File file = new File(string, "system-images");
        file = new File(file, "android-" + this.mVersion.getApiString());
        String string2 = this.mAbi;
        string2 = string2.toLowerCase(Locale.US);
        string2 = string2.replaceAll("[^a-z0-9_-]+", "_");
        string2 = string2.replaceAll("_+", "_");
        file = new File(file, string2);
        return file;
    }

    @Override
    public boolean sameItemAs(Package package_) {
        if (package_ instanceof SystemImagePackage) {
            SystemImagePackage systemImagePackage = (SystemImagePackage)package_;
            return this.getAbi().equals(systemImagePackage.getAbi()) && this.getVersion().equals(systemImagePackage.getVersion());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.mAbi == null ? 0 : this.mAbi.hashCode());
        n = 31 * n + (this.mVersion == null ? 0 : this.mVersion.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof SystemImagePackage)) {
            return false;
        }
        SystemImagePackage systemImagePackage = (SystemImagePackage)object;
        if (this.mAbi == null ? systemImagePackage.mAbi != null : !this.mAbi.equals(systemImagePackage.mAbi)) {
            return false;
        }
        return !(this.mVersion == null ? systemImagePackage.mVersion != null : !this.mVersion.equals(systemImagePackage.mVersion));
    }

    @Override
    protected String comparisonKey() {
        String string = super.comparisonKey();
        int n = string.indexOf("|r:");
        assert (n > 0);
        string = string.substring(0, n) + "|abi:" + this.getAbiDisplayName() + string.substring(n);
        return string;
    }
}

