/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android;

import com.crashlytics.reloc.org.apache.commons.codec.digest.DigestUtils;
import com.crashlytics.reloc.org.apache.commons.io.FileUtils;
import com.crashlytics.tools.android.DeveloperTools;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public abstract class ReleaseNotesManager {
    public static final String HAS_UPDATED_RELEASE_NOTES_KEY = "com.crashlytics.tools.ide.Ide.HAS_UPDATED_RELEASE_NOTES";
    public static final String HAS_UPDATED_RELEASE_NOTES_DEFAULT = "false";
    private static final String RELEASE_NOTES_FILE_NAME = "release_notes.html";
    private static final String RELEASE_NOTES_FILE_NAME_TMP = "release_notes.html.dl";
    private File _releaseNotesDir;

    public ReleaseNotesManager(File dataDir) {
        this._releaseNotesDir = new File(dataDir, ".release_notes");
        if (!this._releaseNotesDir.exists()) {
            this._releaseNotesDir.mkdirs();
        }
    }

    protected File getReleaseNotesDir() {
        return this._releaseNotesDir;
    }

    public abstract String getReleaseNotesUrl();

    public abstract String getBuiltInReleaseNotesPath();

    public abstract boolean hasReleaseNotesUpdate();

    public abstract void setHasReleaseNotesUpdate(boolean var1);

    public boolean downloadReleaseNotes() {
        String releaseNotesUrl = this.getReleaseNotesUrl();
        File destination = this.getReleaseNotesFileTemp();
        DeveloperTools.logD("Downloading release notes from " + releaseNotesUrl + " to " + destination.getAbsolutePath());
        boolean downloadSuccess = false;
        try {
            downloadSuccess = DeveloperTools.getWebApi().downloadFile(new URL(releaseNotesUrl), destination);
        }
        catch (IOException e) {
            DeveloperTools.logW("Failed to download release notes.", e);
            destination.delete();
            return false;
        }
        if (!downloadSuccess) {
            DeveloperTools.logW("Failed to download release notes.", null);
            destination.delete();
        }
        return downloadSuccess;
    }

    public File getReleaseNotesFile() {
        return new File(this._releaseNotesDir, RELEASE_NOTES_FILE_NAME);
    }

    public File getReleaseNotesFileTemp() {
        return new File(this._releaseNotesDir, RELEASE_NOTES_FILE_NAME_TMP);
    }

    public boolean commitDownloadedReleaseNotes() throws ReleaseNotesCommitException {
        boolean changed;
        boolean success = true;
        File oldReleaseNotes = this.getReleaseNotesFile();
        File newReleaseNotes = this.getReleaseNotesFileTemp();
        String newSha = null;
        String oldSha = null;
        if (oldReleaseNotes.exists() && newReleaseNotes.exists()) {
            try {
                byte[] oldBytes = FileUtils.readFileToByteArray(oldReleaseNotes);
                byte[] newBytes = FileUtils.readFileToByteArray(newReleaseNotes);
                oldSha = DigestUtils.shaHex(oldBytes);
                newSha = DigestUtils.shaHex(newBytes);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        boolean bl = changed = this.hasReleaseNotesUpdate() || oldSha == null || newSha == null || !oldSha.equals(newSha);
        if (newReleaseNotes.exists()) {
            success &= oldReleaseNotes.delete() || !oldReleaseNotes.exists();
            success &= newReleaseNotes.renameTo(oldReleaseNotes);
        } else {
            success = false;
        }
        if (!success) {
            throw new ReleaseNotesCommitException();
        }
        this.setHasReleaseNotesUpdate(changed);
        return changed;
    }

    public InputStream getReleaseNotesInput() throws IOException {
        return new FileInputStream(this.getReleaseNotesFile());
    }

    public static class ReleaseNotesCommitException
    extends IOException {
        private static final long serialVersionUID = 8368676710690552969L;
    }
}

