/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.onboard;

import com.crashlytics.reloc.com.google.common.base.Optional;
import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.android.onboard.EmptyOnboarder;
import com.crashlytics.tools.android.onboard.OnboardException;
import com.crashlytics.tools.android.onboard.Onboarder;
import com.crashlytics.tools.android.onboard.WorkspaceChange;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class ProguardConfigWorkspaceChange
implements WorkspaceChange {
    private String _proguardConfigContents;
    private File _destFile;
    private Optional<Callback> _callback;

    public ProguardConfigWorkspaceChange(String proguardConfigContents, File destFile, Optional<Callback> callback) {
        this._proguardConfigContents = proguardConfigContents;
        this._destFile = destFile;
        this._callback = callback;
    }

    public static Onboarder getOnboarder(final String proguardConfigContents, final File destFile, final Optional<Callback> callback) {
        return new EmptyOnboarder(){

            @Override
            public List<WorkspaceChange> getWorkspaceChanges() {
                ProguardConfigWorkspaceChange change = new ProguardConfigWorkspaceChange(proguardConfigContents, destFile, callback);
                return Collections.singletonList(change);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyChange() throws OnboardException {
        try {
            DeveloperTools.logD("Writing proguard config: " + this._destFile);
            FileWriter writer = new FileWriter(this._destFile);
            try {
                writer.write(this._proguardConfigContents);
                if (this._callback.isPresent()) {
                    this._callback.get().changeApplied();
                }
            }
            finally {
                writer.close();
            }
        }
        catch (IOException e) {
            throw new OnboardException("Unable to create proguard config: " + this._destFile.getName(), e);
        }
    }

    public static interface Callback {
        public void changeApplied() throws IOException;
    }
}

