/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.onboard.kits;

import com.crashlytics.api.TwitterToken;
import com.crashlytics.reloc.com.google.common.base.Optional;
import com.crashlytics.tools.android.onboard.Kit;
import com.crashlytics.tools.android.onboard.OnboardingConstants;
import com.crashlytics.tools.android.onboard.TwitterAuthCodeBlockFactory;
import com.crashlytics.tools.android.onboard.dsl.NestedMethodInvocation;
import com.crashlytics.tools.android.onboard.dsl.transform.CodeChangeBuilder;
import com.crashlytics.tools.android.onboard.kits.KitUtils;
import java.util.List;

public class KitClassTransformFactory {
    public static CodeChangeBuilder create(boolean hasKitsEnabled, Kit kit, Optional<TwitterToken> token) {
        List<String> importsForKit = KitUtils.importsForKits(kit, hasKitsEnabled);
        if (kit.isSameArtifact(OnboardingConstants.TWITTER_CORE_KIT)) {
            return KitClassTransformFactory.createTwitterInjections(KitUtils.createConstructorArg(kit), OnboardingConstants.getStartMethod(hasKitsEnabled), importsForKit, token);
        }
        if (kit.isSameArtifact(OnboardingConstants.LEGACY_CRASHLYTICS_KIT)) {
            return KitClassTransformFactory.createLegacyInjections(OnboardingConstants.getLegacyStartMethod(), importsForKit);
        }
        return KitClassTransformFactory.createDefaultInjections(KitUtils.createConstructorArg(kit), OnboardingConstants.getStartMethod(hasKitsEnabled), importsForKit);
    }

    public static CodeChangeBuilder createTwitterInjections(String baseKit, NestedMethodInvocation method, List<String> imports, Optional<TwitterToken> twitterToken) {
        String key = twitterToken.isPresent() ? twitterToken.get().consumerKey : "TWITTER_KEY";
        String secret = twitterToken.isPresent() ? twitterToken.get().secret : "TWITTER_SECRET";
        String obfuscationComment = TwitterAuthCodeBlockFactory.getObfuscationComment();
        String keyConstant = TwitterAuthCodeBlockFactory.getTwitterKeyConstant(key);
        String secretConstant = TwitterAuthCodeBlockFactory.getTwitterSecretConstant(secret);
        return CodeChangeBuilder.create().addImports(imports.toArray(new String[imports.size()])).transformIf(CodeChangeBuilder.addParameterAt(method, baseKit), CodeChangeBuilder.insertStatementBefore(method, "final TwitterAuthConfig authConfig = new TwitterAuthConfig(TWITTER_KEY, TWITTER_SECRET);"), CodeChangeBuilder.insertFields(obfuscationComment, keyConstant, secretConstant));
    }

    public static CodeChangeBuilder createLegacyInjections(NestedMethodInvocation invocation, List<String> imports) {
        return CodeChangeBuilder.create().addImports(imports.toArray(new String[imports.size()])).add(invocation);
    }

    public static CodeChangeBuilder createDefaultInjections(String baseName, NestedMethodInvocation method, List<String> imports) {
        return CodeChangeBuilder.create().addImports(imports.toArray(new String[imports.size()])).with(CodeChangeBuilder.addParameterAt(method, baseName));
    }
}

