/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.onboard.kits;

import com.crashlytics.reloc.com.google.common.base.Optional;
import com.crashlytics.reloc.com.google.common.collect.Lists;
import com.crashlytics.tools.android.onboard.Kit;
import com.crashlytics.tools.android.onboard.OnboardingConstants;
import com.crashlytics.tools.android.onboard.TwitterFeature;
import com.crashlytics.tools.android.onboard.dsl.NestedMethodInvocation;
import java.util.ArrayList;
import java.util.List;

public class KitUtils {
    public static List<Kit> resolveKitDependencies(Kit kit, Optional<Kit.Feature<?>> feature) {
        ArrayList<Kit> kits = Lists.newArrayList(kit);
        if (kit.isSameArtifact(OnboardingConstants.TWITTER_CORE_KIT)) {
            switch ((TwitterFeature)((Object)feature.get().context)) {
                case Syndication: {
                    kits.add(OnboardingConstants.TWITTER_TWEET_UI_KIT);
                    break;
                }
                case Digits: {
                    kits.add(OnboardingConstants.TWITTER_DIGITS_KIT);
                    break;
                }
            }
        }
        return kits;
    }

    public static List<String> importsForKits(Kit kit, boolean hasKitsEnabled) {
        ArrayList<String> imports = Lists.newArrayList();
        if (hasKitsEnabled) {
            imports.add("io.fabric.sdk.android.Fabric");
        }
        imports.add(kit.getKitClass().getFullyQualifiedClassName());
        if (kit.isSameArtifact(OnboardingConstants.TWITTER_CORE_KIT)) {
            imports.add("com.twitter.sdk.android.core.TwitterAuthConfig");
        }
        return imports;
    }

    public static String createConstructorArg(Kit kit) {
        return String.format("new %s(%s)", kit.getKitClass().getClassName(), kit.getArgs());
    }

    public static String createMethodInvocation(NestedMethodInvocation method, List<String> parameters) {
        StringBuilder methodInvocation = new StringBuilder(method.className);
        methodInvocation.append(".").append(method.methodName).append("(this);");
        for (String parameter : parameters) {
            String param = ", " + parameter;
            methodInvocation.insert(methodInvocation.length() - 2, param);
        }
        return methodInvocation.toString();
    }
}

