/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.project;

import com.crashlytics.api.TwitterToken;
import com.crashlytics.reloc.com.google.common.collect.ImmutableMap;
import com.crashlytics.tools.utils.PropertiesUtils;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

public class CrashlyticsPropertiesBuilder {
    public static String CRASHLYTICS_PROPERTIES_MESSAGE = "Contains API Secret used to validate your application. Commit to internal source control; avoid making secret public.";
    private final File _propertiesFile;
    private final ImmutableMap.Builder<String, String> _propertiesBuilder;

    public CrashlyticsPropertiesBuilder(File propertiesFile) {
        this(propertiesFile, new ImmutableMap.Builder<String, String>());
    }

    public CrashlyticsPropertiesBuilder(File propertiesFile, ImmutableMap.Builder<String, String> propertiesBuilder) {
        this._propertiesFile = propertiesFile;
        this._propertiesBuilder = propertiesBuilder;
    }

    public CrashlyticsPropertiesBuilder addTwitterToken(TwitterToken twitterToken) {
        return new CrashlyticsPropertiesBuilder(this._propertiesFile, this._propertiesBuilder.put("twitterPluginId", twitterToken.id));
    }

    public CrashlyticsPropertiesBuilder addBuildSecret(String buildSecret) {
        return new CrashlyticsPropertiesBuilder(this._propertiesFile, this._propertiesBuilder.put("apiSecret", buildSecret));
    }

    public void write() throws IOException {
        if (!this._propertiesFile.exists()) {
            this._propertiesFile.createNewFile();
        }
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this._propertiesBuilder.build());
        PropertiesUtils.injectPropertyInFile(this._propertiesFile, properties, CRASHLYTICS_PROPERTIES_MESSAGE);
    }
}

