/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.project;

import com.crashlytics.reloc.com.google.common.base.Optional;
import com.crashlytics.tools.android.project.AndroidProject;
import com.crashlytics.tools.android.project.AndroidProjectStructure;
import com.crashlytics.tools.android.project.DefaultManifestData;
import com.crashlytics.tools.android.project.ManifestFileProvider;
import com.crashlytics.tools.android.project.StandardAndroidProject;
import com.crashlytics.tools.utils.PropertiesUtils;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public class StandardAndroidProjectFactory {
    public AndroidProject create(Properties properties) throws IOException {
        File projectPath = properties.containsKey("projectPath") ? new File(properties.getProperty("projectPath", ".")) : new File(".");
        File projectFilesRoot = new File(new File(projectPath, "src"), "main");
        if (!projectFilesRoot.exists()) {
            projectFilesRoot = projectPath;
        }
        File manifestPath = properties.containsKey("androidManifest") ? new File(properties.getProperty("androidManifest")) : new File(projectFilesRoot, "AndroidManifest.xml");
        File resPath = properties.containsKey("androidRes") ? new File(properties.getProperty("androidRes")) : new File(projectFilesRoot, "res");
        File assetsPath = properties.containsKey("androidAssets") ? new File(properties.getProperty("androidAssets")) : new File(projectFilesRoot, "assets");
        File propertiesFile = StandardAndroidProject.getPropertiesLoc(projectPath);
        if (properties.containsKey("properties")) {
            propertiesFile = new File(properties.getProperty("properties"));
        }
        File ndkOutPath = properties.containsKey("androidNdkOut") ? new File(properties.getProperty("androidNdkOut")) : new File(projectFilesRoot, "obj");
        File ndkLibsOutPath = properties.containsKey("androidNdkLibsOut") ? new File(properties.getProperty("androidNdkLibsOut")) : new File(projectFilesRoot, "libs");
        AndroidProjectStructure structure = new AndroidProjectStructure(projectPath, manifestPath, resPath, assetsPath, StandardAndroidProject.getDataDirectory(projectPath), propertiesFile, ndkOutPath, ndkLibsOutPath);
        return this.create(structure, properties);
    }

    public AndroidProject create(AndroidProjectStructure structure) throws IOException {
        return this.createTypedProject(structure, "STANDARD_PROJECT");
    }

    public AndroidProject create(AndroidProjectStructure structure, Properties properties) throws IOException {
        return this.createTypedProject(structure, properties, "STANDARD_PROJECT");
    }

    protected AndroidProject createTypedProject(AndroidProjectStructure structure, String projectType) throws IOException {
        Properties properties;
        try {
            properties = PropertiesUtils.read(structure.getPropertyFile());
        }
        catch (IOException e) {
            properties = new Properties();
        }
        return this.createTypedProject(structure, properties, projectType);
    }

    protected StandardAndroidProject createTypedProject(AndroidProjectStructure structure, Properties properties, String projectType) throws IOException {
        String appName;
        File projectPath = structure.getProjectRootDir();
        if (!projectPath.isDirectory()) {
            throw new IllegalArgumentException("Project path is not a directory: " + projectPath);
        }
        File manifestFile = structure.getManifestFile();
        File dataPath = structure.getProjectDataPath();
        File resDir = structure.getResourceDir();
        File assetsDir = structure.getAssetsDir();
        File resourceFile = properties.containsKey("resFile") ? new File(properties.getProperty("resFile")) : StandardAndroidProject.getStringResourceLoc(resDir);
        DefaultManifestData manifestData = DefaultManifestData.createManifest(new ManifestFileProvider(structure.getManifestFile()), resDir);
        if (!projectPath.isDirectory()) {
            throw new IllegalArgumentException("Project path is not a directory: " + projectPath);
        }
        Optional<String> manifestApiKey = manifestData.getApiKey();
        String apiKey = manifestApiKey.isPresent() ? manifestApiKey.get() : properties.getProperty("apiKey");
        String buildSecret = properties.getProperty("apiSecret");
        Optional<String> twitterId = Optional.fromNullable(properties.getProperty("twitterPluginId"));
        String packageName = properties.getProperty("renamedPackage");
        if (packageName == null || packageName.isEmpty()) {
            packageName = manifestData.getPackageName();
        }
        if ((appName = manifestData.getApplicationName()) == null) {
            appName = packageName;
        }
        File launcherIcon = manifestData.getLauncherIcon();
        File ndkOutDir = structure.getNdkOutDir();
        File ndkLibsOutDir = structure.getNdkLibsOutDir();
        return new StandardAndroidProject(projectPath, manifestFile, dataPath, structure.getPropertyFile(), resourceFile, assetsDir, manifestData, projectType, buildSecret, apiKey, packageName, appName, launcherIcon, twitterId, ndkOutDir, ndkLibsOutDir);
    }
}

