/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.project.library;

import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.android.project.library.AndroidLibrary;
import com.crashlytics.tools.utils.PropertiesUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ProjectProperties {
    private static final String PROPERTIES_MESSAGE = "This project.properties file is being managed by Crashlytics.";
    public static final String ANDROID_LIBRARY_REFERENCE = "android.library.reference";
    private File _propertiesFile;
    private String _relativeKitsFolder;

    private ProjectProperties(File propertiesFile, String relativeKitsFolder) {
        this._propertiesFile = propertiesFile;
        this._relativeKitsFolder = relativeKitsFolder;
    }

    public static ProjectProperties getKitProperties(File projectPropsFile) {
        return new ProjectProperties(projectPropsFile, "../");
    }

    public static ProjectProperties getUserProjectProperties(File projectPropsFile) {
        return new ProjectProperties(projectPropsFile, "kit-libs/");
    }

    public void configureLibrary(Iterable<AndroidLibrary> aarDependencies, Integer targetPlatform, Map<String, String> projectNames) throws IOException {
        Properties properties = PropertiesUtils.read(this._propertiesFile);
        properties.put("android.library", "true");
        properties.put("target", "android-" + targetPlatform);
        ProjectProperties.linkProject(aarDependencies, properties, this._relativeKitsFolder, projectNames);
        PropertiesUtils.write(this._propertiesFile, properties, PROPERTIES_MESSAGE);
    }

    public void configureApp(List<AndroidLibrary> aarDependencies, Map<String, String> projectNames) throws IOException {
        Properties properties = PropertiesUtils.read(this._propertiesFile);
        ProjectProperties.linkProject(aarDependencies, properties, this._relativeKitsFolder, projectNames);
        PropertiesUtils.write(this._propertiesFile, properties, PROPERTIES_MESSAGE);
    }

    public void removeKits() throws IOException {
        Properties properties = PropertiesUtils.read(this._propertiesFile);
        Set<String> libraryReferences = ProjectProperties.splitOnLibraryRefrences(properties);
        ProjectProperties.removeKits(libraryReferences, this._relativeKitsFolder);
        ProjectProperties.addLibraries(libraryReferences, properties);
        PropertiesUtils.write(this._propertiesFile, properties, PROPERTIES_MESSAGE);
    }

    public Set<String> getReferences() throws IOException {
        return ProjectProperties.splitOnLibraryRefrences(PropertiesUtils.read(this._propertiesFile));
    }

    private static Set<String> splitOnLibraryRefrences(Properties properties) {
        HashSet<String> libraryReferences = new HashSet<String>();
        for (String property : properties.stringPropertyNames()) {
            if (!property.trim().startsWith(ANDROID_LIBRARY_REFERENCE)) continue;
            libraryReferences.add(properties.getProperty(property));
            properties.remove(property);
        }
        return libraryReferences;
    }

    private static void linkProject(Iterable<AndroidLibrary> aarDependencies, Properties properties, String prefixToKits, Map<String, String> projectNames) {
        Set<String> libraryReferences = ProjectProperties.splitOnLibraryRefrences(properties);
        ProjectProperties.removeKits(libraryReferences, prefixToKits);
        for (AndroidLibrary dependencyLib : aarDependencies) {
            libraryReferences.add(prefixToKits + projectNames.get(dependencyLib.name));
        }
        ProjectProperties.addLibraries(libraryReferences, properties);
    }

    private static void addLibraries(Set<String> libraryReferences, Properties properties) {
        int count = 1;
        for (String lib : libraryReferences) {
            properties.put("android.library.reference." + String.valueOf(count), lib);
            ++count;
        }
    }

    private static void removeKits(Set<String> libraryReferences, String prefixToKits) {
        Iterator<String> libItr = libraryReferences.iterator();
        while (libItr.hasNext()) {
            String lib = libItr.next();
            if (lib.startsWith(prefixToKits)) {
                libItr.remove();
                continue;
            }
            DeveloperTools.logD("Crashlytics is maintaining the library: " + lib);
        }
    }
}

