/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.utils.io;

import com.crashlytics.tools.utils.io.SeekableInputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;

public class SeekableByteArrayInputStream
extends SeekableInputStream {
    private final ExtendedByteArrayInputStream _source;

    public SeekableByteArrayInputStream(byte[] buffer) {
        this._source = new ExtendedByteArrayInputStream(buffer);
    }

    @Override
    public void seek(long offset) throws IOException {
        this._source.setPosition((int)offset);
    }

    @Override
    public long getCurrentOffset() throws IOException {
        return this._source.getPosition();
    }

    @Override
    public void readFully(byte[] buffer, int off, int len) throws IOException {
        this._source.readFully(buffer, off, len);
    }

    @Override
    public int read() throws IOException {
        return this._source.read();
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        return this._source.read(bytes);
    }

    @Override
    public int read(byte[] bytes, int off, int len) throws IOException {
        return this._source.read(bytes, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this._source.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this._source.available();
    }

    @Override
    public void close() throws IOException {
        this._source.close();
    }

    @Override
    public synchronized void mark(int mark) {
        this._source.mark(mark);
    }

    @Override
    public synchronized void reset() throws IOException {
        this._source.reset();
    }

    @Override
    public boolean markSupported() {
        return this._source.markSupported();
    }

    private static final class ExtendedByteArrayInputStream
    extends ByteArrayInputStream {
        public ExtendedByteArrayInputStream(byte[] buffer) {
            super(buffer);
        }

        public void setPosition(int position) {
            if (position < 0 || position >= this.count) {
                throw new ArrayIndexOutOfBoundsException();
            }
            this.pos = position;
        }

        public void readFully(byte[] buffer, int off, int len) throws IOException {
            if (len + this.pos > this.count) {
                throw new EOFException();
            }
            super.read(buffer, off, len);
        }

        public int getPosition() {
            return this.pos;
        }
    }
}

