/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics;

import com.crashlytics.AbstractCrashlyticsMojo;
import com.crashlytics.DeveloperToolsUtils;
import com.crashlytics.MojoLogger;
import com.crashlytics.tools.android.DeveloperTools;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Parameter;

@org.apache.maven.plugins.annotations.Mojo(name="GenerateResources", defaultPhase=LifecyclePhase.INITIALIZE)
public class CrashlyticsGenerateResourcesMojo
extends AbstractCrashlyticsMojo {
    @Parameter
    private String projectPath;
    @Parameter
    private String androidResPath;
    @Parameter
    private String androidAssetsPath;
    @Parameter
    private String androidManifestPath;
    @Parameter(defaultValue="crashlytics.properties", alias="properties_path")
    private String propertiesPath;
    @Parameter(defaultValue="false", alias="require_upload_success")
    private String requireUploadSuccess;

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)"Crashlytics - GenerateResources");
        this.getLog().debug((CharSequence)("projectPath: " + this.projectPath));
        this.getLog().debug((CharSequence)("androidResPath: " + this.androidResPath));
        this.getLog().debug((CharSequence)("androidAssetsPath: " + this.androidAssetsPath));
        this.getLog().debug((CharSequence)("androidManifestPath: " + this.androidManifestPath));
        this.getLog().debug((CharSequence)("requireUploadSuccess: " + this.requireUploadSuccess));
        this.getLog().debug((CharSequence)("propertiesPath: " + this.propertiesPath));
        if (this.projectPath == null) {
            this.projectPath = this.getDefaultProjectPath();
            this.getLog().debug((CharSequence)("projectPath set to Maven project basedir: " + this.projectPath));
        }
        DeveloperTools.setLogger((DeveloperTools.Logger)new MojoLogger((Mojo)this));
        DeveloperToolsUtils util = new DeveloperToolsUtils(this.projectPath, this.androidResPath, this.androidAssetsPath, this.androidManifestPath, this.propertiesPath, this.requireUploadSuccess, false, null, this.getRenamedPackage());
        util.cleanupResourceFile();
        util.uploadDeobsFiles();
        util.generateResourceFile();
    }
}

