/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics;

import com.crashlytics.tools.android.DeveloperTools;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DeveloperToolsUtils {
    private final String _projectPath;
    private final String _androidResPath;
    private final String _androidAssetsPath;
    private final String _androidManifestPath;
    private final String _propertiesPath;
    private final String _requireUploadSuccess;
    private final boolean _proguardDetected;
    private final String _mappingPath;
    private final String _renamedPackage;

    public DeveloperToolsUtils(String projectPath, String androidResPath, String androidAssetsPath, String androidManifestPath, String propertiesPath, String requireUploadSuccess, boolean proguardDetected, String mappingPath, String renamedPackage) {
        this._projectPath = projectPath;
        this._androidResPath = androidResPath;
        this._androidAssetsPath = androidAssetsPath;
        this._androidManifestPath = androidManifestPath;
        this._propertiesPath = propertiesPath;
        this._requireUploadSuccess = requireUploadSuccess;
        this._proguardDetected = proguardDetected;
        this._mappingPath = mappingPath;
        this._renamedPackage = renamedPackage;
    }

    public void storeDeobsFile() {
        ArrayList<String> args = new ArrayList<String>();
        this.appendDefaultArgs(args);
        this.appendValueArgTo(args, "-storeDeobs", this._mappingPath);
        if (this._proguardDetected) {
            this.appendArgTo(args, "-obfuscating");
            this.appendValueArgTo(args, "-obfuscator", "proguard");
            this.appendValueArgTo(args, "-obVer", "4.7");
        }
        DeveloperTools.processArgs((String[])args.toArray(new String[args.size()]));
    }

    public void cleanupResourceFile() {
        ArrayList<String> args = new ArrayList<String>();
        this.appendDefaultArgs(args);
        this.appendArgTo(args, "-cleanupResourceFile");
        DeveloperTools.processArgs((String[])args.toArray(new String[args.size()]));
    }

    public void uploadDeobsFiles() {
        ArrayList<String> args = new ArrayList<String>();
        this.appendDefaultArgs(args);
        if (Boolean.valueOf(this._requireUploadSuccess).booleanValue()) {
            this.appendArgTo(args, "-requireUploadSuccess");
        }
        this.appendArgTo(args, "-uploadDeobs");
        DeveloperTools.processArgs((String[])args.toArray(new String[args.size()]));
    }

    public void generateResourceFile() {
        ArrayList<String> args = new ArrayList<String>();
        this.appendDefaultArgs(args);
        this.appendArgTo(args, "-buildEvent");
        this.appendOptionalArgTo(args, "-tool", DeveloperToolsUtils.class.getPackage().getImplementationTitle());
        this.appendOptionalArgTo(args, "-version", DeveloperToolsUtils.class.getPackage().getImplementationVersion());
        this.appendArgTo(args, "-generateResourceFile");
        DeveloperTools.processArgs((String[])args.toArray(new String[args.size()]));
    }

    private void appendDefaultArgs(List<String> args) {
        this.appendOptionalArgTo(args, "-projectPath", this._projectPath);
        this.appendOptionalArgTo(args, "-androidRes", this._androidResPath);
        this.appendOptionalArgTo(args, "-androidAssets", this._androidAssetsPath);
        this.appendOptionalArgTo(args, "-androidManifest", this._androidManifestPath);
        this.appendOptionalArgTo(args, "-renamedPackage", this._renamedPackage);
        if (this._propertiesPath != null && new File(this._propertiesPath).exists()) {
            this.appendOptionalArgTo(args, "-properties", this._propertiesPath);
        }
    }

    private void appendOptionalArgTo(List<String> args, String paramName, String paramValue) {
        if (paramValue != null) {
            args.add(paramName);
            args.add(paramValue);
        }
    }

    private void appendValueArgTo(List<String> args, String paramName, String paramValue) {
        args.add(paramName);
        args.add(paramValue);
    }

    private void appendArgTo(List<String> args, String paramName) {
        args.add(paramName);
    }
}

