/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.org.apache.http.impl.client.cache;

import com.crashlytics.reloc.org.apache.http.annotation.Immutable;
import com.crashlytics.reloc.org.apache.http.client.cache.InputLimit;
import com.crashlytics.reloc.org.apache.http.client.cache.Resource;
import com.crashlytics.reloc.org.apache.http.client.cache.ResourceFactory;
import com.crashlytics.reloc.org.apache.http.impl.client.cache.HeapResource;
import com.crashlytics.reloc.org.apache.http.impl.client.cache.IOUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

@Immutable
public class HeapResourceFactory
implements ResourceFactory {
    public Resource generate(String requestId, InputStream instream, InputLimit limit) throws IOException {
        int l;
        ByteArrayOutputStream outstream = new ByteArrayOutputStream();
        byte[] buf = new byte[2048];
        long total = 0L;
        while ((l = instream.read(buf)) != -1) {
            outstream.write(buf, 0, l);
            if (limit == null || (total += (long)l) <= limit.getValue()) continue;
            limit.reached();
            break;
        }
        return this.createResource(outstream.toByteArray());
    }

    public Resource copy(String requestId, Resource resource) throws IOException {
        byte[] body;
        if (resource instanceof HeapResource) {
            body = ((HeapResource)resource).getByteArray();
        } else {
            ByteArrayOutputStream outstream = new ByteArrayOutputStream();
            IOUtils.copyAndClose(resource.getInputStream(), outstream);
            body = outstream.toByteArray();
        }
        return this.createResource(body);
    }

    Resource createResource(byte[] buf) {
        return new HeapResource(buf);
    }
}

