/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.org.apache.http.impl.io;

import com.crashlytics.reloc.org.apache.http.annotation.NotThreadSafe;
import com.crashlytics.reloc.org.apache.http.io.BufferInfo;
import com.crashlytics.reloc.org.apache.http.io.SessionInputBuffer;
import com.crashlytics.reloc.org.apache.http.util.Args;
import java.io.IOException;
import java.io.InputStream;

@NotThreadSafe
public class IdentityInputStream
extends InputStream {
    private final SessionInputBuffer in;
    private boolean closed = false;

    public IdentityInputStream(SessionInputBuffer in) {
        this.in = Args.notNull(in, "Session input buffer");
    }

    public int available() throws IOException {
        if (this.in instanceof BufferInfo) {
            return ((BufferInfo)((Object)this.in)).length();
        }
        return 0;
    }

    public void close() throws IOException {
        this.closed = true;
    }

    public int read() throws IOException {
        if (this.closed) {
            return -1;
        }
        return this.in.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            return -1;
        }
        return this.in.read(b, off, len);
    }
}

