/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.onboard;

import com.crashlytics.reloc.com.google.common.base.Optional;
import com.crashlytics.reloc.com.google.common.collect.Lists;
import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.android.onboard.Code;
import com.crashlytics.tools.android.onboard.CodeChange;
import com.crashlytics.tools.android.onboard.EmptyOnboarder;
import com.crashlytics.tools.android.onboard.Kit;
import com.crashlytics.tools.android.onboard.OnboardException;
import com.crashlytics.tools.android.onboard.OnboardingConstants;
import com.crashlytics.tools.android.onboard.Repository;
import com.crashlytics.tools.android.onboard.StubCode;
import com.crashlytics.tools.utils.FileUtils;
import com.crashlytics.tools.utils.GradleParser;
import com.crashlytics.tools.utils.GradleTokenizer;
import com.crashlytics.tools.utils.GradleUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class AndroidGradleOnboarder
extends EmptyOnboarder {
    private final Repository _pluginRepository;
    private final Repository _kitRepository;
    private final Kit _kit;
    private final GradleParser _parser;
    private final Code _gradleCode;

    public static AndroidGradleOnboarder createDefaultAndroidGradleOnboarder(GradleParser parser, Code code) {
        return new AndroidGradleOnboarder(OnboardingConstants.CRASHLYTICS_REPOSITORY, OnboardingConstants.CRASHLYTICS_REPOSITORY, OnboardingConstants.LEGACY_CRASHLYTICS_KIT, parser, code);
    }

    public AndroidGradleOnboarder(Repository pluginRepository, Repository kitRepository, Kit kit, GradleParser parser, Code gradleCode) {
        this._pluginRepository = pluginRepository;
        this._kitRepository = kitRepository;
        this._kit = kit;
        this._gradleCode = gradleCode;
        this._parser = parser;
    }

    private static List<CodeChange.BlockChange> getKitChanges(Kit kit, GradleParser parser, Repository pluginRepositiry, Repository kitRepository, String lineSeparator) throws IOException, LineNotFoundException {
        ArrayList<CodeChange.BlockChange> changes = Lists.newArrayList();
        changes.addAll(AndroidGradleOnboarder.getCommonChanges(kitRepository, pluginRepositiry, parser, lineSeparator));
        if (OnboardingConstants.LEGACY_CRASHLYTICS_KIT.isSameArtifact(kit)) {
            changes.addAll(AndroidGradleOnboarder.getCrashlyticsKitChanges(kit, parser, lineSeparator));
            return changes;
        }
        List<CodeChange.BlockChange> upgrade = AndroidGradleOnboarder.getCrashlyticsKitUpgradeChanges(parser, lineSeparator);
        changes.addAll(upgrade);
        if (upgrade.isEmpty() && OnboardingConstants.isCrashlyticsKit(kit)) {
            changes.addAll(AndroidGradleOnboarder.getCrashlyticsKitChanges(kit, parser, lineSeparator));
        } else if (OnboardingConstants.TWITTER_SOCIAL_KIT.isSameArtifact(kit)) {
            changes.addAll(AndroidGradleOnboarder.getTwitterKitChanges(kit, parser, lineSeparator));
        } else if (OnboardingConstants.MOPUB_KIT.isSameArtifact(kit)) {
            changes.addAll(AndroidGradleOnboarder.getMoPubKitChanges(kit, parser, lineSeparator));
        }
        return changes;
    }

    private static List<CodeChange.BlockChange> getCommonChanges(Repository kitRepository, Repository pluginRepository, GradleParser parser, String lineSeparator) throws IOException, LineNotFoundException {
        GradleParser.SearchResult repositoryResult;
        LinkedList<CodeChange.BlockChange> changes = new LinkedList<CodeChange.BlockChange>();
        GradleParser.SearchResult buildscriptResult = parser.findNestedClosures("buildscript");
        if (!buildscriptResult.wasFound()) {
            AndroidGradleOnboarder.addInsertion(changes, 0, GradleUtils.getTabs(0), "buildscript {", lineSeparator, GradleUtils.getTabs(1), "repositories {", lineSeparator, GradleUtils.indentString(pluginRepository.getGradleRepositoryString(lineSeparator), 2, lineSeparator), lineSeparator, GradleUtils.getTabs(1), "}", lineSeparator, lineSeparator, GradleUtils.getTabs(1), "dependencies {", lineSeparator, GradleUtils.getTabs(2), "classpath 'com.crashlytics.tools.gradle:crashlytics-gradle:1.+'", lineSeparator, GradleUtils.getTabs(1), "}", lineSeparator, GradleUtils.getTabs(0), "}", lineSeparator);
        } else {
            GradleParser.SearchResult buildscriptRepositorySearchResult = parser.findNestedClosuresEnding("buildscript", "repositories");
            if (!buildscriptRepositorySearchResult.wasFound()) {
                AndroidGradleOnboarder.addInsertion(changes, buildscriptResult.getPosition(), lineSeparator, GradleUtils.getTabs(1), "repositories {", lineSeparator, GradleUtils.indentString(pluginRepository.getGradleRepositoryString(lineSeparator), 2, lineSeparator), lineSeparator, GradleUtils.getTabs(1), "}", lineSeparator);
            } else {
                Optional<String> scoped = parser.getScopeContent("buildscript", "repositories");
                if (scoped.isPresent() && !scoped.get().contains("http://download.crashlytics.com/maven")) {
                    AndroidGradleOnboarder.addInsertion(changes, buildscriptRepositorySearchResult.getPosition(), lineSeparator, GradleUtils.indentString(pluginRepository.getGradleRepositoryString(lineSeparator), 2, lineSeparator));
                }
            }
            GradleParser.SearchResult buildscriptDependencyResult = parser.findNestedClosuresEnding("buildscript", "dependencies");
            if (!buildscriptDependencyResult.wasFound()) {
                AndroidGradleOnboarder.addInsertion(changes, buildscriptResult.getPosition(), lineSeparator, GradleUtils.getTabs(1), "dependencies {", lineSeparator, GradleUtils.getTabs(2), "classpath 'com.crashlytics.tools.gradle:crashlytics-gradle:1.+'", lineSeparator, GradleUtils.getTabs(1), "}", lineSeparator);
            } else if (!parser.contains("com.crashlytics.tools.gradle:crashlytics-gradle:")) {
                AndroidGradleOnboarder.addInsertion(changes, buildscriptDependencyResult.getPosition(), lineSeparator, GradleUtils.getTabs(2), "classpath 'com.crashlytics.tools.gradle:crashlytics-gradle:1.+'");
            }
        }
        GradleParser.SearchResult applyAndroidResult = parser.findTokenSet(GradleParser.ANDROID_PLUGIN_STRINGS);
        if (!applyAndroidResult.wasFound()) {
            throw new LineNotFoundException("Failed to find apply plugin: 'android' line.");
        }
        GradleParser.SearchResult applyCrashlyticsResult = parser.findTokenSet(GradleParser.CRASHLYTICS_PLUGIN_STRINGS);
        if (!applyCrashlyticsResult.wasFound()) {
            AndroidGradleOnboarder.addInsertion(changes, applyAndroidResult.getPosition(), lineSeparator, "apply plugin: 'crashlytics'");
        }
        if (!(repositoryResult = parser.findNestedClosuresEnding("repositories")).wasFound()) {
            AndroidGradleOnboarder.addInsertion(changes, applyAndroidResult.getPosition(), lineSeparator, lineSeparator, GradleUtils.getTabs(0), "repositories {", lineSeparator, GradleUtils.indentString(kitRepository.getGradleRepositoryString(lineSeparator), 1, lineSeparator), lineSeparator, GradleUtils.getTabs(0), "}", lineSeparator);
        } else {
            Optional<String> scoped = parser.getScopeContent("repositories");
            if (scoped.isPresent() && !scoped.get().contains(kitRepository.getUrl())) {
                AndroidGradleOnboarder.addInsertion(changes, repositoryResult.getPosition(), lineSeparator, GradleUtils.indentString(kitRepository.getGradleRepositoryString(lineSeparator), 1, lineSeparator));
            }
        }
        return changes;
    }

    private static List<CodeChange.BlockChange> getCrashlyticsKitUpgradeChanges(GradleParser parser, String lineSeparator) throws IOException, LineNotFoundException {
        GradleParser.SearchResult dependencyPosition = parser.findNestedClosuresEnding("dependencies");
        if (!dependencyPosition.wasFound()) {
            return Collections.emptyList();
        }
        Optional<String> scoped = parser.getScopeContent("dependencies");
        if (!scoped.isPresent()) {
            return Collections.emptyList();
        }
        LinkedList<CodeChange.BlockChange> changes = Lists.newLinkedList();
        String bare = OnboardingConstants.LEGACY_CRASHLYTICS_KIT.getBareGradleDependencyString();
        String wrapped = OnboardingConstants.LEGACY_CRASHLYTICS_KIT.getGradleDependencyString(lineSeparator);
        if (scoped.get().contains(bare)) {
            int start = dependencyPosition.getPosition() - scoped.get().length() + scoped.get().indexOf(wrapped);
            int end = start + wrapped.length();
            changes.add(new CodeChange.Deletion(start, end));
        }
        changes.addAll(AndroidGradleOnboarder.getCrashlyticsKitChanges(OnboardingConstants.CRASHLYTICS_KIT, parser, lineSeparator));
        return changes;
    }

    private static List<CodeChange.BlockChange> getTwitterKitChanges(Kit kit, GradleParser parser, String lineSeparator) throws IOException, LineNotFoundException {
        LinkedList<CodeChange.BlockChange> changes = Lists.newLinkedList();
        GradleParser.SearchResult dependencyPosition = parser.findNestedClosuresEnding("dependencies");
        GradleParser.SearchResult applyAndroidResult = parser.findTokenSet(GradleParser.ANDROID_PLUGIN_STRINGS);
        if (!dependencyPosition.wasFound()) {
            AndroidGradleOnboarder.addInsertion(changes, applyAndroidResult.getPosition(), lineSeparator, GradleUtils.getTabs(0), "dependencies {", lineSeparator, GradleUtils.indentString(kit.getGradleDependencyString(lineSeparator), 1, lineSeparator), lineSeparator, GradleUtils.getTabs(0), "}", lineSeparator);
        } else if (!parser.contains(kit.getBareGradleDependencyString())) {
            AndroidGradleOnboarder.addInsertion(changes, dependencyPosition.getPosition(), lineSeparator, GradleUtils.indentString(kit.getGradleDependencyString(lineSeparator), 1, lineSeparator));
        }
        return changes;
    }

    private static List<CodeChange.BlockChange> getCrashlyticsKitChanges(Kit kit, GradleParser parser, String lineSeparator) throws IOException, LineNotFoundException {
        LinkedList<CodeChange.BlockChange> changes = Lists.newLinkedList();
        GradleParser.SearchResult dependencyPosition = parser.findNestedClosuresEnding("dependencies");
        GradleParser.SearchResult applyAndroidResult = parser.findTokenSet(GradleParser.ANDROID_PLUGIN_STRINGS);
        if (!dependencyPosition.wasFound()) {
            AndroidGradleOnboarder.addInsertion(changes, applyAndroidResult.getPosition(), lineSeparator, GradleUtils.getTabs(0), "dependencies {", lineSeparator, GradleUtils.indentString(kit.getGradleDependencyString(lineSeparator), 1, lineSeparator), lineSeparator, GradleUtils.getTabs(0), "}", lineSeparator);
        } else if (!parser.contains(kit.getBareGradleDependencyString())) {
            AndroidGradleOnboarder.addInsertion(changes, dependencyPosition.getPosition(), lineSeparator, GradleUtils.indentString(kit.getGradleDependencyString(lineSeparator), 1, lineSeparator));
        }
        return changes;
    }

    private static List<CodeChange.BlockChange> getMoPubKitChanges(Kit kit, GradleParser parser, String lineSeparator) throws IOException, LineNotFoundException {
        LinkedList<CodeChange.BlockChange> changes = Lists.newLinkedList();
        GradleParser.SearchResult dependencyPosition = parser.findNestedClosuresEnding("dependencies");
        GradleParser.SearchResult applyAndroidResult = parser.findTokenSet(GradleParser.ANDROID_PLUGIN_STRINGS);
        if (!dependencyPosition.wasFound()) {
            AndroidGradleOnboarder.addInsertion(changes, applyAndroidResult.getPosition(), lineSeparator, GradleUtils.getTabs(0), "dependencies {", lineSeparator, GradleUtils.indentString(kit.getGradleDependencyString(lineSeparator), 1, lineSeparator), lineSeparator, GradleUtils.getTabs(0), "}", lineSeparator);
        } else if (!parser.contains(kit.getBareGradleDependencyString())) {
            AndroidGradleOnboarder.addInsertion(changes, dependencyPosition.getPosition(), lineSeparator, GradleUtils.indentString(kit.getGradleDependencyString(lineSeparator), 1, lineSeparator));
        }
        return changes;
    }

    @Override
    public List<CodeChange> getCodeChanges() throws OnboardException {
        try {
            String codeAsString = this._gradleCode.getCode();
            String lineSeparator = this.getLineSeparator(codeAsString);
            List<CodeChange.BlockChange> changes = AndroidGradleOnboarder.getKitChanges(this._kit, this._parser, this._pluginRepository, this._kitRepository, lineSeparator);
            return Collections.singletonList(new CodeChange("build.gradle", this._gradleCode, changes));
        }
        catch (IOException e) {
            DeveloperTools.logW("Crashlytics was unable to parse build.gradle", e);
        }
        catch (LineNotFoundException e) {
            DeveloperTools.logW("Crashlytics was unable to find a necessary line in the file.", e);
        }
        catch (Exception e) {
            DeveloperTools.logW("Crashlytics was unable to parse file.", e);
        }
        return Collections.singletonList(new CodeChange("build.gradle", this._gradleCode, Collections.<CodeChange.BlockChange>emptyList()));
    }

    @Override
    public List<CodeChange> getCodeChangeDirections() throws OnboardException {
        String panelName = "build.gradle";
        try {
            InputStream manifestStream = AndroidGradleOnboarder.class.getClassLoader().getResourceAsStream("examples/build.gradle.txt");
            String gradleContents = FileUtils.streamToString(manifestStream);
            manifestStream.close();
            StubCode exampleCode = new StubCode(gradleContents);
            AndroidGradleOnboarder onboarder = AndroidGradleOnboarder.createDefaultAndroidGradleOnboarder(new GradleParser(new GradleTokenizer(gradleContents)), exampleCode);
            return onboarder.getCodeChanges();
        }
        catch (OnboardException e) {
            DeveloperTools.logE("Could not onboard build.gradle example at examples/build.gradle.txt", e);
            return Collections.singletonList(CodeChange.createEmptyChange(panelName));
        }
        catch (IOException e) {
            DeveloperTools.logE("Could not load example source: examples/build.gradle.txt", e);
            return Collections.singletonList(CodeChange.createEmptyChange(panelName));
        }
    }

    private static void addInsertion(List<CodeChange.BlockChange> changesToCodeBlocks, int insertPosition, String ... text) {
        StringBuilder sb = new StringBuilder();
        for (String item : text) {
            sb.append(item);
        }
        CodeChange.Insertion insertion = new CodeChange.Insertion(insertPosition, sb.toString());
        DeveloperTools.logD(insertion.toString());
        changesToCodeBlocks.add(insertion);
    }

    protected String getLineSeparator(String contents) {
        return FileUtils.getLineSeparator(contents);
    }

    private static class LineNotFoundException
    extends Exception {
        public LineNotFoundException(String lineDescription) {
            super(lineDescription);
        }
    }
}

