/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.api.storage.conversion;

import com.crashlytics.api.storage.detail.Header;
import com.crashlytics.api.storage.exception.InvalidFormatException;
import com.crashlytics.reloc.org.apache.commons.io.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

public class Overlay {
    private static final Charset UTF_8 = Charset.forName("UTF-8");

    public static byte[] bytes(Header header, String data) {
        byte[] stream = data.getBytes(UTF_8);
        byte[] raw = new byte[Header.size() + stream.length];
        System.arraycopy(header.bytes(), 0, raw, 0, Header.size());
        System.arraycopy(stream, 0, raw, Header.size(), stream.length);
        return raw;
    }

    private static byte[] read(InputStream in, int length) throws InvalidFormatException, IOException {
        byte[] raw = new byte[length];
        if (IOUtils.read(in, raw, 0, length) != length) {
            throw new InvalidFormatException();
        }
        return raw;
    }

    public static Header extractHeader(InputStream in) throws InvalidFormatException, IOException {
        return Header.from(Overlay.read(in, Header.size()));
    }

    public static String extractText(InputStream in, int length) throws InvalidFormatException, IOException {
        return new String(Overlay.read(in, length), UTF_8);
    }
}

